#include "cCrossCall.h"
#include "cPicture.h"

CrossCallInfo gCci;
static BOOL gEventsInited = FALSE;
static BOOL gAppRunning = FALSE;
static char *gAppName;
static HANDLE gCLEAN_DONE;
static HANDLE gOS_DONE;
static DWORD gCleanThreadId;
static DWORD gOsThreadId;
static HANDLE ghOSThreadHandle = NULL;
static HINSTANCE ghInst;
static HWND ghMainWindow = NULL;
/* RWS ... */
static HWND gNextClipboardViewer = NULL;			// PA: added from Ronny
/* ... RWS */
static HWND ghMenuBarWindow = NULL;
static int gMenuBarWindowHeight;
static HACCEL gAcceleratorTable = NULL;
static PAINTSTRUCT gPaintStruct;
static HWND ghTopDocWindow = NULL;
static HWND gActiveDialog = NULL;
static int gModalDialogCount = 0;
static BOOL gInWMSIZE = FALSE;
static BOOL gInMouseDown = FALSE;
static HCURSOR ghFatCrossCursor = NULL;
static HCURSOR ghHiddenCursor = NULL;
static int gProhibitWindowActivation = 0;
static int gDoubleDownDistance = -1;
static int gGlobalCursorCode = -1;
static int gNextItemHandle = 0;
static int gClicks = 0;
static UINT gClTime;
static int gClX, gClY;
static HWND gClHwnd;
static HFONT gDlogFont = NULL;
static HFONT gWinFont  = NULL;			/* PA: new global: the font used for controls in windows. */
static int gComboSelection = -1;
static BOOL gInKey = FALSE;
static int gCurChar;					/* PA: gCurChar previously was a char, now an int. */
static LONG gPrevMsgTime = -1;
static BOOL gMessStored = FALSE;
static MSG gStoredMess;
static BOOL gIdleTimerOn = FALSE;
static LONG stdEditCallback = 0;		/* PA: new global: the standard internal Windows callback routine of edit controls. */

static CrossCallInfo *MakeQuitCci (CrossCallInfo * pcci);
static CrossCallInfo *MakeReturn0Cci (CrossCallInfo * pcci);
static CrossCallInfo *MakeReturn1Cci (CrossCallInfo * pcci, int v);
static CrossCallInfo *MakeReturn2Cci (CrossCallInfo * pcci, int v1, int v2);
static CrossCallInfo *MakeReturn3Cci (CrossCallInfo * pcci, int v1, int v2, int v3);
static CrossCallInfo *MakeReturn4Cci (CrossCallInfo * pcci, int v1, int v2, int v3, int v4);

/*		Because the Windows gAcceleratorTable cannot be changed dynamically
		we maintain a private table (ShortcutTable)
*/

#define kInitialShortcutTableSize		100

#define kVariableSize	1

struct ShortcutTable
{
	int st_size;
	int st_used;
	ACCEL st_shortcuts[kVariableSize];
};

typedef struct ShortcutTable *ShortcutTable;

static ShortcutTable gShortcutTable	= NULL;
static BOOL gAcceleratorTableIsUpToDate	= TRUE;

static ShortcutTable
AllocateShortcutTable (int size)
{
	ShortcutTable table;

	rprintf ("AllocateShortcutTable: size = %d\n", size);

	table = (ShortcutTable) rmalloc (sizeof (struct ShortcutTable) + (size - kVariableSize) * sizeof (ACCEL));

	table->st_size = size;
	table->st_used = 0;

	return (table);
}

static void
CollectShortcuts (ShortcutTable table)
{
	int from, to, used;

	rprintf ("CollectShortcuts\n");

	used	= table->st_used;

	/* find unused entry */
	for (from	= 0; from < used; from++)
		if (table->st_shortcuts[from].key == 0)
			break;

	/* shift entries */
	to = from;
	for (; from < used; from++)
		if (table->st_shortcuts[from].key != 0)
			table->st_shortcuts[to++] = table->st_shortcuts[from];

	table->st_used = to;
}

static ShortcutTable
ReallocateShortcutTable (ShortcutTable oldTable)
{
	int i, oldSize, newSize;
	ShortcutTable newTable;

	rprintf ("ReallocateShortcutTable\n");

	oldSize = oldTable->st_size;
	newSize = oldSize * 2;

	newTable = (ShortcutTable) AllocateShortcutTable (newSize);

	for (i = 0; i < oldSize; i++)
		newTable->st_shortcuts[i] = oldTable->st_shortcuts[i];

	newTable->st_used = oldSize;

	rfree (oldTable);

	return (newTable);
}

static ShortcutTable
AddShortcutToTable (int key, int id, ShortcutTable table)
{
	ACCEL *entry;

	rprintf ("AddShortcutToTable: key = %c, id = %d\n", key, id);

	if (table->st_used >= table->st_size)
	{
		CollectShortcuts (table);
		if (table->st_used >= table->st_size)
			table = ReallocateShortcutTable (table);
	}

	entry = &table->st_shortcuts[table->st_used++];
	entry->fVirt = FCONTROL | FVIRTKEY;
	entry->key = (WORD) ((BYTE) VkKeyScan ((char) key));
	entry->cmd = (WORD) id;

	gAcceleratorTableIsUpToDate = FALSE;

	return (table);
}

static void
RemoveShortcutFromTable (int id, ShortcutTable table)
{
	int i, used;

	rprintf ("RemoveShortcutFromTable: id = %d\n", id);

	used = table->st_used;

	for (i = 0; i < used; i++)
		if (table->st_shortcuts[i].cmd == id)
		{
			table->st_shortcuts[i].cmd = 0;
			break;		/* assume there's only one shortcut per id */
		}

	gAcceleratorTableIsUpToDate = FALSE;
}

static void
UpdateAcceleratorTable (void)
{
	ShortcutTable shortcutTable;

	shortcutTable = gShortcutTable;

	if (shortcutTable != NULL)
	{
		int i;
		rprintf ("UpdateAcceleratorTable (%d shortcuts)\n", shortcutTable->st_used);
		for (i = 0; i < shortcutTable->st_used; i++)
		{
			ACCEL *shortcut;

			shortcut = &shortcutTable->st_shortcuts[i];
			rprintf ("\tshortcut: key = %c, id = %d\n", shortcut->key, shortcut->cmd);
		}
		if (gAcceleratorTable != NULL)
			DestroyAcceleratorTable (gAcceleratorTable);

		CollectShortcuts (shortcutTable);
		gAcceleratorTable = CreateAcceleratorTable (shortcutTable->st_shortcuts, shortcutTable->st_used);
	}
	else
		gAcceleratorTable = NULL;

	gAcceleratorTableIsUpToDate = TRUE;
}

static void
InitGlobals (void)
{
	gAppRunning = FALSE;
	ghOSThreadHandle = NULL;
	ghMainWindow = NULL;
/* RWS ... */
	gNextClipboardViewer = NULL;			// PA: added from Ronny
/* ... RWS */
	ghMenuBarWindow = NULL;
	gAcceleratorTable = NULL;
	ghTopDocWindow = NULL;
	gActiveDialog = NULL;
	gModalDialogCount = 0;
	gInWMSIZE = FALSE;
	gInMouseDown = FALSE;
	ghFatCrossCursor = NULL;
	ghHiddenCursor = NULL;
	gProhibitWindowActivation = 0;
	gDoubleDownDistance = -1;
	gGlobalCursorCode = -1;
	gNextItemHandle = 0;
	gClicks = 0;
	gDlogFont = NULL;
	gWinFont  = NULL;
	gComboSelection = -1;
	gInKey = FALSE;
	gPrevMsgTime = -1;
	gMessStored = FALSE;
	gIdleTimerOn = FALSE;
}

static char MenuBarClassName[] = "__CleanMenuBar";
static char ControlClassName[] = "__CleanControl";
static char CompoundClassName[] = "__CleanCompoundControl";		/* PA: new class for CompoundControls */
static char DocWindowClassName[] = "__CleanWindow";
static char MainWindowClassName[] = "__CleanMainWindow";

#define CleanFixedWindowStyle (WS_SYSMENU | WS_OVERLAPPED )
#define CleanScrollWindowStyle (WS_SYSMENU | WS_OVERLAPPED | WS_THICKFRAME | WS_HSCROLL | WS_VSCROLL)

static int
nCopyAnsiToWideChar (LPWORD lpWCStr, LPSTR lpAnsiIn)
{
	int nChar = 0;

	do
	{
		*lpWCStr++ = (WORD) * lpAnsiIn;
		nChar++;
	} while (*lpAnsiIn++);

	return nChar;
}

static char *
CorrectMenuItemText (char *source)
{
	int ampersandcount;
	int index, destindex;
	int sourcelength, destlength;
	char *dest;

	sourcelength = rstrlen (source);
	ampersandcount = 0;

	for (index = 0; index < sourcelength; index++)
	{
		if (source[index] == '&')
		{
			ampersandcount++;
		}
	}
	destlength = sourcelength + ampersandcount;
	dest = rmalloc (destlength + 1);
	destindex = 0;
	for (index = 0; index < destlength; index++)
	{
		dest[destindex] = source[index];
		destindex++;

		if (source[index] == '&')
		{
			dest[destindex] = '&';
			destindex++;
		}
	}
	dest[destlength] = '\0';
	return dest;
}

static void
GetAppFileName (void)
{
	char path[MAX_PATH + 1];
	int length, index;
	int start, end;
	BOOL newword;

	length = GetModuleFileName (NULL, path, MAX_PATH);

	for (index = length - 1; path[index] != '.'; index--)
		;
	end = index - 1;

	for (index = end;
		 path[index] != '/' &&
		 path[index] != '\\' &&
		 path[index] != ':';
		 index--)
		;

	start = index + 1;

	if (end - start > 31)
		end = start + 31;

	if (end - start >= 0)
	{
		gAppName = rmalloc (end - start + 2);
		for (index = 0; index <= end - start; index++)
			gAppName[index] = path[start + index];
		gAppName[index] = '\0';
	}
	else
	{
		gAppName = "Clean Application";
	}

	newword = TRUE;
	for (index = 0; gAppName[index] != '\0'; index++)
	{
		if (gAppName[index] >= 'A' && gAppName[index] <= 'Z' && !newword)
			gAppName[index] = gAppName[index] - ('A' - 'a');

		if (gAppName[index] == ' ')
			newword = TRUE;
		else
			newword = FALSE;
	}
}

extern EXPORT_TO_CLEAN PSTR
WinGetAppPath (void)
{
	char *path;
	int idx, length;

	path = rmalloc (261);

	length = GetModuleFileName (NULL, path, 260);

	for (idx = length - 1;
		 path[idx] != '/' &&
		 path[idx] != '\\' &&
		 path[idx] != ':';
		 idx--)
		;

	path[idx + 1] = 0;

	return path;		/* relying on the calling clean function to
						   de-allocate path. */
}

static BYTE FatCrossCursorANDmask[128] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x80, 0xff, 0xff, 0xff, 0x80, 0x7f, 0xff,
	0xff, 0x80, 0x7f, 0xff, 0xff, 0x80, 0x7f, 0xff,

	0xff, 0x80, 0x7f, 0xff, 0xff, 0x80, 0x7f, 0xff,
	0xe0, 0x00, 0x03, 0xff, 0xe0, 0x3e, 0x01, 0xff,
	0xe0, 0x3e, 0x01, 0xff, 0xe0, 0x3e, 0x01, 0xff,
	0xe0, 0x3e, 0x01, 0xff, 0xe0, 0x3e, 0x01, 0xff,

	0xe0, 0x00, 0x01, 0xff, 0xf0, 0x00, 0x01, 0xff,
	0xff, 0x80, 0x7f, 0xff, 0xff, 0x80, 0x7f, 0xff,
	0xff, 0x80, 0x7f, 0xff, 0xff, 0x80, 0x7f, 0xff,
	0xff, 0x80, 0x7f, 0xff, 0xff, 0xc0, 0x7f, 0xff,

	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

static BYTE FatCrossCursorXORmask[128] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00,
	0x00, 0x3e, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00,

	0x00, 0x3e, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00,
	0x00, 0x3e, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x00,
	0x0f, 0xe3, 0xf8, 0x00, 0x0f, 0xe3, 0xf8, 0x00,
	0x0f, 0xe3, 0xf8, 0x00, 0x0f, 0xff, 0xf8, 0x00,

	0x00, 0x3e, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00,
	0x00, 0x3e, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00,
	0x00, 0x3e, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static BYTE HiddenCursorANDmask[128] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

static BYTE HiddenCursorXORmask[128] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static HCURSOR
GetFatCrossCursor (void)
{
	if (ghFatCrossCursor != NULL)
		return ghFatCrossCursor;

	ghFatCrossCursor = CreateCursor (ghInst,
									 12, 13,	/* Hot spot */
									 32, 32,	/* width, heigth */
									 FatCrossCursorANDmask,
									 FatCrossCursorXORmask
		);

	return ghFatCrossCursor;
}

static HCURSOR
GetHiddenCursor (void)
{
	if (ghHiddenCursor != NULL)
		return ghHiddenCursor;

	ghHiddenCursor = CreateCursor (ghInst,
								   16, 16,		/* Hot spot */
								   32, 32,		/* width, heigth */
								   HiddenCursorANDmask,
								   HiddenCursorXORmask
		);

	return ghHiddenCursor;
}

static void
DeleteCursors (void)
{
	if (ghFatCrossCursor != NULL)
	{
		DestroyCursor (ghFatCrossCursor);
		ghFatCrossCursor = NULL;
	}

	if (ghHiddenCursor != NULL)
	{
		DestroyCursor (ghHiddenCursor);
		ghHiddenCursor = NULL;
	}
}

static int
GetDoubleDownDistance (void)
{
	if (gDoubleDownDistance == -1)
		gDoubleDownDistance = GetSystemMetrics (SM_CXDOUBLECLK) / 2;

	return gDoubleDownDistance;
}

extern EXPORT_TO_CLEAN OS
WinSetDoubleDownDist (int dd, OS ios)
{
	gDoubleDownDistance = dd;
	return ios;
}

static HITEM
NextItemHandle (void)
{
	int oldhandle;

	oldhandle = gNextItemHandle;

	gNextItemHandle++;

	if (oldhandle > gNextItemHandle)
	{
		MessageBeep (0xFFFFFFFF);
		MessageBeep (0xFFFFFFFF);
		MessageBeep (0xFFFFFFFF);
		MessageBeep (0xFFFFFFFF);
		MessageBeep (0xFFFFFFFF);
		MessageBeep (0xFFFFFFFF);
		MessageBeep (0xFFFFFFFF);
		MessageBeep (0xFFFFFFFF);
		MessageBeep (0xFFFFFFFF);
		MessageBeep (0xFFFFFFFF);
		MessageBeep (0xFFFFFFFF);
	}

	return gNextItemHandle;
}

static HCURSOR
SetCursorFromCode (int code)
{
	switch (code)
	{
		case CURSARROW:
			return SetCursor (LoadCursor (0, IDC_ARROW));
		case CURSBUSY:
			return SetCursor (LoadCursor (0, IDC_WAIT));
		case CURSIBEAM:
			return SetCursor (LoadCursor (0, IDC_IBEAM));
		case CURSCROSS:
			return SetCursor (LoadCursor (0, IDC_CROSS));
		case CURSFATCROSS:
			return SetCursor (GetFatCrossCursor ());
		case CURSHIDDEN:
			return SetCursor (GetHiddenCursor ());
		default:
			return NULL;
	}
}

static BOOL
IsApplicationWindow (HWND hw)
{
	while (hw != NULL && hw != ghMainWindow)
		hw = GetWindow (hw, GW_OWNER);

	return (hw != NULL);
}

static HWND
ApplicationWindowUnderCursor (void)
{
	POINT p;
	HWND hwin;

	GetCursorPos (&p);
	hwin = WindowFromPoint (p);

	if (IsApplicationWindow (hwin))
		return hwin;
	else
		return NULL;
}

static int CALLBACK
EnumFontNameProc (ENUMLOGFONT FAR * lpelf,		/* pointer to logical-font
												   data */
				  NEWTEXTMETRIC FAR * lpntm,	/* pointer to physical-font
												   data */
				  int fontType, /* type of font */
				  LPARAM lParam /* address of application-defined data	*/
)
{
#pragma unused (lpntm, fontType, lParam)
	SendMessage1ToClean (CcCbFONTNAME, lpelf->elfLogFont.lfFaceName);

	return 1;
}

static int CALLBACK
EnumFontSizeProc (ENUMLOGFONT FAR * lpelf,		/* pointer to logical-font
												   data  */
				  NEWTEXTMETRIC FAR * lpntm,	/* pointer to physical-font
												   data  */
				  int fontType, /* type of font  */
				  LPARAM lParam /* address of application-defined data	*/
)
{
#pragma unused (lpelf, lParam)

	SendMessage2ToClean (CcCbFONTSIZE,
						 lpntm->tmHeight - lpntm->tmInternalLeading,
						 fontType == TRUETYPE_FONTTYPE);

	if (fontType == TRUETYPE_FONTTYPE)
		return 0;
	else
		return 1;
}

static void
AdjustMenuBarName (void)
{
	char apptitle[70];
	char wintitle[32];

	if (ghTopDocWindow != NULL)
	{
		GetWindowText (ghTopDocWindow, wintitle, 31);
		wsprintf (apptitle, "%s - [%s]", gAppName, wintitle);
		SetWindowText (ghMenuBarWindow, apptitle);
		SetWindowText (ghMainWindow, apptitle);

	}
	else
	{
		SetWindowText (ghMenuBarWindow, gAppName);
		SetWindowText (ghMainWindow, gAppName);
	}
}

static void
W95GetMenuBarWindowDimensions (POINT * dim)
{
	dim->x = GetSystemMetrics (SM_CXMAXIMIZED)
		- 2 * GetSystemMetrics (SM_CXSIZEFRAME);
	dim->y = 2 * GetSystemMetrics (SM_CYSIZEFRAME) +
		GetSystemMetrics (SM_CYCAPTION) +
		GetSystemMetrics (SM_CYMENU);
}

static int
GetMenuBarOffSet (void)
{
	if (ghMenuBarWindow)
		return gMenuBarWindowHeight - GetSystemMetrics (SM_CYSIZEFRAME);
	else
		return 0;
}

static void
W95AdjustFixedWindowDimensions (POINT * dim)
{
	dim->x += 2 * GetSystemMetrics (SM_CXFIXEDFRAME);
	dim->y += 2 * GetSystemMetrics (SM_CYFIXEDFRAME) +
		GetSystemMetrics (SM_CYCAPTION);
}

static void
W95AdjustScrollWindowDimensions (POINT * dim)
{

	dim->x += 2 * GetSystemMetrics (SM_CXSIZEFRAME) + 4;
	dim->y += 2 * GetSystemMetrics (SM_CYSIZEFRAME) + 4 +
		GetSystemMetrics (SM_CYCAPTION);
}

/* PA: new routine to adjust the dimensions of a Clean window with W95 frame dimensions. */
static void
W95AdjustCleanWindowDimensions (DWORD styleFlags, POINT * dim)
{
	if (styleFlags&WS_THICKFRAME != 0)
	{	/* resizable window */
		dim->x += 2 * GetSystemMetrics (SM_CXSIZEFRAME) + 4;
		dim->y += 2 * GetSystemMetrics (SM_CYSIZEFRAME) + 4 + GetSystemMetrics (SM_CYCAPTION);
	} else
	{	/* fixed size window */
		dim->x += 2 * GetSystemMetrics (SM_CXFIXEDFRAME);
		dim->y += 2 * GetSystemMetrics (SM_CYFIXEDFRAME) + GetSystemMetrics (SM_CYCAPTION);
	}
}

static BOOL
GetMinMaxInfoFromClean (HWND hWin, POINT * winmax, POINT * winmin)
{
	SendMessage1ToClean (CcWmGETMINMAXINFO, hWin);
	if (gCci.mess == CcRETURN0)
		return FALSE;

	if (winmax)
	{
		winmax->x = gCci.p1;
		winmax->y = gCci.p2;
	}
	if (winmin)
	{
		winmin->x = gCci.p3;
		winmin->y = gCci.p4;
	}

	return TRUE;
}

/* PA: What ActivateTopWindow actually do?? */
static BOOL
ActivateTopWindow (void)
{
	HWND hwin, hw;

	hwin = GetWindow (ghMainWindow, GW_HWNDFIRST);

	while (hwin != NULL)
	{
		hw = hwin;
		while (hw != NULL && hw != ghMainWindow)
		{
			hw = GetWindow (hw, GW_OWNER);
		}

		if (hw == ghMainWindow && hwin != ghMenuBarWindow)
		{
			break;
		}
		else
			hwin = GetWindow (hwin, GW_HWNDNEXT);
	}

	if (hwin != NULL)
	{
		if (gProhibitWindowActivation == 0)
			SetActiveWindow (hwin);
	}
	else
	{
		ghTopDocWindow = NULL;
		if (GetActiveWindow () != ghMenuBarWindow && ghMenuBarWindow != 0 && gProhibitWindowActivation == 0)
			SetActiveWindow (ghMenuBarWindow);
	}

	return hwin != NULL;
}

static void
SendActivateToClean (HWND hWin)
{
	SendMessage1ToClean (CcWmACTIVATE, hWin);
}

static void
SendDeactivateToClean (HWND hWin)
{
	SendMessage1ToClean (CcWmDEACTIVATE, hWin);
}

static int
GetModifiers (void)
{
	int mods;
	mods = 0;

	if (GetKeyState (VK_SHIFT) < 0)
		mods |= SHIFTBIT;
	if (GetKeyState (VK_CONTROL) < 0)
		mods |= CTRLBIT;
	if (GetKeyState (VK_MENU) < 0)
		mods |= ALTBIT;

	return mods;
}

/*	PA: GetParentWindow is used internally to determine the handle of the true parent window.
		It searches through all parents until the last one is found (because of CompoundControls).
*/
static HWND
GetParentWindow (HWND hwnd)
{
	HWND curparent,tempparent;
	tempparent = hwnd;
	curparent  = hwnd;

	while ( tempparent!=NULL )
	{
		curparent  = tempparent;
		tempparent = GetParent (curparent);
	};
	return curparent;
}

/*	PA: new procedure that translates virtual key codes to the codes shared with Clean.
	This procedure has been filtered from RbrtTranslateMessage.
	If the keycode could not be translated, zero is returned.
*/
static int
CheckVirtualKeyCode (int keycode)
{
	int c = 0;
	switch (keycode)
	{
		case VK_UP:
			c = WinUpKey;
			break;
		case VK_DOWN:
			c = WinDownKey;
			break;
		case VK_LEFT:
			c = WinLeftKey;
			break;
		case VK_RIGHT:
			c = WinRightKey;
			break;
		case VK_PRIOR:
			c = WinPgUpKey;
			break;
		case VK_NEXT:
			c = WinPgDownKey;
			break;
		case VK_END:
			c = WinEndKey;
			break;
		case VK_HOME:
			c = WinBeginKey;
			break;
		case VK_BACK:
			c = WinBackSpKey;
			break;
		case VK_DELETE:
			c = WinDelKey;
			break;
		case VK_TAB:
			c = WinTabKey;
			break;
		case VK_RETURN:
			c = WinReturnKey;
			break;
		case VK_ESCAPE:
			c = WinEscapeKey;
			break;
		case VK_HELP:
			c = WinHelpKey;
			break;
		case VK_F1:
			c = WinF1Key;
			break;
		case VK_F2:
			c = WinF2Key;
			break;
		case VK_F3:
			c = WinF3Key;
			break;
		case VK_F4:
			c = WinF4Key;
			break;
		case VK_F5:
			c = WinF5Key;
			break;
		case VK_F6:
			c = WinF6Key;
			break;
		case VK_F7:
			c = WinF7Key;
			break;
		case VK_F8:
			c = WinF8Key;
			break;
		case VK_F9:
			c = WinF9Key;
			break;
		case VK_F10:
			c = WinF10Key;
			break;
		case VK_F11:
			c = WinF11Key;
			break;
		case VK_F12:
			c = WinF12Key;
			break;
	}
	return c;
}

static void
SendKeyDownToClean (HWND hwnd, int c)
{
	SendMessage5ToClean (CcWmKEYBOARD, GetParentWindow (hwnd), hwnd, c, KEYDOWN, GetModifiers ());
}

static void
SendKeyStillDownToClean (HWND hwnd, int c)
{
	SendMessage5ToClean (CcWmKEYBOARD, GetParentWindow (hwnd), hwnd, c, KEYREPEAT, GetModifiers ());
}

static void
SendKeyUpToClean (HWND hwnd, int c)
{
	SendMessage5ToClean (CcWmKEYBOARD, GetParentWindow (hwnd), hwnd, c, KEYUP, GetModifiers ());
}

static void
SendMouseUpToClean (HWND hWin, int x, int y)
{
	gInMouseDown = FALSE;
	KillTimer (hWin, (UINT) - 1);
	SendMessage6ToClean (CcWmMOUSE, GetParentWindow (hWin), hWin, BUTTONUP, x, y, GetModifiers ());
}

static void
SendMouseStillDownToClean (HWND hWin, int x, int y)
{
	SendMessage6ToClean (CcWmMOUSE, GetParentWindow (hWin), hWin, BUTTONSTILLDOWN, x, y, GetModifiers ());
}

static void
SendMouseStillUpToClean (HWND hWin, int x, int y)
{
	SendMessage6ToClean (CcWmMOUSE, GetParentWindow (hWin), hWin, BUTTONSTILLUP, x, y, GetModifiers ());
}

static BOOL
inDcSpaceTime (HWND curwin, int curx, int cury, UINT curtime,
			   HWND prevwin, int prevx, int prevy, UINT prevtime)
{
	if (rabs (curx - prevx) > GetDoubleDownDistance ())
		return FALSE;

	if (rabs (cury - prevy) > GetDoubleDownDistance ())
		return FALSE;

	if (curtime - prevtime > GetDoubleClickTime ())
		return FALSE;

	if (curwin != prevwin)
		return FALSE;

	return TRUE;
}

static void
SendMouseDownToClean (HWND hWin, int x, int y)
{
	gInMouseDown = TRUE;
	SetCapture (hWin);
	SetFocus (hWin);		/* PA: pressing the mouse must also set the keyboard input to that object. */
	SetTimer (hWin, (UINT) - 1, (UINT) 1, NULL);

	if (gClicks != 0 && !inDcSpaceTime (hWin, x, y, GetMessageTime (), gClHwnd, gClX, gClY, gClTime))
		gClicks = 0;

	if (gClicks == 0)
	{
		gClTime = GetMessageTime ();
		gClX = x;
		gClY = y;
		gClHwnd = hWin;
	}

	gClicks++;

	SendMessage6ToClean (CcWmMOUSE, GetParentWindow (hWin), hWin, gClicks, x, y, GetModifiers ());
	if (gClicks == 3)
		gClicks = 0;
}

static LRESULT CALLBACK
MenuWindowProcedure (HWND hWin,
					 UINT uMess,
					 WPARAM wPara,
					 LPARAM lPara)
{
	LPMINMAXINFO pmmi;

	printMessage ("MenuBarWindow", hWin, uMess, wPara, lPara);
	switch (uMess)
	{
		case WM_SETCURSOR:
			{
				if (gGlobalCursorCode == -1)
				{
					return DefWindowProc (hWin, uMess, wPara, lPara);
				}
				else
				{
					SetCursorFromCode (gGlobalCursorCode);
				}
			} break;
		case WM_ENTERMENULOOP:
			{
				gProhibitWindowActivation++;
			} break;
		case WM_EXITMENULOOP:
			{
				gProhibitWindowActivation--;
			} break;
		case WM_GETMINMAXINFO:
			pmmi = (LPMINMAXINFO) lPara;
			pmmi->ptMaxSize.y = gMenuBarWindowHeight;
			pmmi->ptMaxTrackSize.y = gMenuBarWindowHeight;
			break;
		case WM_COMMAND:
			ActivateTopWindow ();
			SendMessage2ToClean (CcWmCOMMAND, LOWORD (wPara), GetModifiers ());	/* PA: CcWmCOMMAND now also send modifiers to Clean. */
			break;
		case WM_SYSCOMMAND:
			if (wPara == SC_MINIMIZE)
			{
				SetActiveWindow (ghMainWindow);
				SendMessage (ghMainWindow, uMess, wPara, lPara);
			}
			else
			{
				if (wPara == SC_KEYMENU)
					if (GetActiveWindow () != ghMenuBarWindow)
						SetActiveWindow (ghMenuBarWindow);
				return (DefWindowProc (hWin, uMess, wPara, lPara));
			}
			break;
		case WM_ENABLE:
			{
				SendMessage (hWin, WM_NCACTIVATE, wPara, 0);
			}
			break;
		case WM_NCACTIVATE:
			{
				if (IsWindowEnabled (hWin) && gAppRunning)
					wPara = TRUE;
				return DefWindowProc (hWin, uMess, wPara, lPara);
			}
			/* RWS ... */			// PA: added from Ronny
		case WM_CREATE:
			gNextClipboardViewer	= SetClipboardViewer (hWin);
			rprintf ("Clipboard view installed\n");
			break;
		case WM_DRAWCLIPBOARD:
			{
				rprintf ("DRAWCLIPBOARD\n");
			    SendMessage0ToClean( CcWmDRAWCLIPBOARD );

				if (gNextClipboardViewer != NULL)
					SendMessage (gNextClipboardViewer, uMess,wPara,lPara);

			}
			break;
		case WM_CHANGECBCHAIN:
			rprintf ("CHANGECBCHAIN\n");
			if ((HWND) wPara == gNextClipboardViewer)
				gNextClipboardViewer	= (HWND) lPara;
			else if (gNextClipboardViewer != NULL)
					SendMessage (gNextClipboardViewer, uMess, wPara, lPara);
			break;
/* ... RWS */
		default:
			return DefWindowProc (hWin, uMess, wPara, lPara);
			break;
	}
	return 0;
}

static BOOL CALLBACK
SetControlFontProc (HWND hchild,		/* handle to child window */
					LPARAM lParam		/* application-defined value */
)
{
	HFONT hfont;

	hfont = (HFONT) lParam;

	if (hfont)
		SendMessage (hchild, WM_SETFONT, (WPARAM) hfont, MAKELPARAM (TRUE, 0));

	return TRUE;
}

static LRESULT CALLBACK
DialogProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	printMessage ("DIALOG PROCEDURE", hwnd, message, wParam, lParam);

	switch (message)
	{
		case WM_CLOSE:
			{
				SendMessage1ToClean (CcWmLOSEMODELESSDLOG, hwnd);
				/* PA: CcWmLOSEMODELESSDIALOG only request closing; the actual closing must be done by Clean callback
				if (gCci.p1)
				{
					DestroyWindow (hwnd);
				}
				*/
				return TRUE;
			}
			break;
		case WM_SETCURSOR:
			{
				if (gGlobalCursorCode == -1)
				{
					return FALSE;
				}
				else
				{
					SetCursorFromCode (gGlobalCursorCode);
					SetWindowLong (hwnd, DWL_MSGRESULT, TRUE);
					return TRUE;
				}
			} break;
		case WM_ENTERIDLE:
			{
				SendMessage0ToClean (CcWmIDLETIMER);
				return FALSE;		/* PA: added */
			} break;
		case WM_ENTERMENULOOP:
			{
				gProhibitWindowActivation++;
				return FALSE;		/* PA: added */
			} break;
		case WM_EXITMENULOOP:
			{
				gProhibitWindowActivation--;
				return FALSE;		/* PA: added */
			} break;
		case WM_TIMER:
			{
				SendMessage2ToClean (CcWmTIMER, wParam, GetMessageTime ());
				return FALSE;		/* PA: added */
			} break;
		/* PA: previous implementation of WM_ACTIVATE. 
		case WM_ACTIVATE:
			{
				switch (LOWORD (wParam))
				{
					case WA_ACTIVE:
					case WA_CLICKACTIVE:
						gActiveDialog = hwnd;
						break;
					case WA_INACTIVE:
						gActiveDialog = NULL;
						break;
				}
			}
			break;
		PA: end of previous implementation. */
		case WM_ACTIVATE:
			{
				switch (LOWORD (wParam))
				{
					case WA_ACTIVE:
					case WA_CLICKACTIVE:
						SendActivateToClean (hwnd);
						gActiveDialog = hwnd;
						break;
					case WA_INACTIVE:
						SendDeactivateToClean (hwnd);
						gActiveDialog = NULL;
						break;
				}
				return TRUE;		/* PA: added */
			}
			break;
		case WM_COMMAND:
			{
				switch (HIWORD (wParam))
				{
					case BN_CLICKED:
						{
							if (lParam != 0)
							{
								/* PA: modifiers are now also sent to Clean */
								SendMessage3ToClean (CcWmBUTTONCLICKED, hwnd, lParam, GetModifiers ());
							}
							else if (LOWORD (wParam) == 2)
							{
								SendMessage1ToClean (CcWmLOSEMODELESSDLOG, hwnd);
								/* PA: CcWmLOSEMODELESSDIALOG only request closing; the actual closing must be done by Clean callback
								if (gCci.p1)
								{
									DestroyWindow (hwnd);
								}
								*/
							}
							return TRUE;	/* PA: added */
						}
						break;
					case CBN_SETFOCUS:
						{
							gComboSelection = SendMessage ((HWND) lParam, CB_GETCURSEL, 0, 0);
							return FALSE;	/* PA: added */
						}
						break;
					case CBN_KILLFOCUS:
						{
							gComboSelection = -1;
							return FALSE;	/* PA: added */
						}
						break;
					case CBN_SELENDOK:
						{
							char text[256];
							int newsel;
							HWND combo;

							combo = (HWND) lParam;
							newsel = SendMessage (combo, CB_GETCURSEL, 0, 0);
							SendMessage (combo, CB_GETLBTEXT, newsel, (LPARAM) text);
							if (!SendMessage (combo, CB_GETITEMDATA, newsel, 0))
							{
								SendMessage (combo, CB_SETCURSEL, gComboSelection, (LPARAM) text);
								MessageBeep (0xFFFFFFFF);
							}
							else
							{
								gComboSelection = newsel;
								SendMessage3ToClean (CcWmCOMBOSELECT, hwnd, combo, newsel);
							}
							return TRUE;	/* PA: else part first returned FALSE */
						}
						break;
				}
				return FALSE;		/* PA: added*/
			} break;
		case WM_INITDIALOG:
			{
				int x, y, w, h;
				HWND defctrl;

				SendMessage1ToClean (CcWmINITDIALOG, hwnd);

				x = gCci.p1;
				y = gCci.p2;
				w = gCci.p3;
				h = gCci.p4;
				defctrl = (HWND) gCci.p5;

				w += 2 * GetSystemMetrics (SM_CXFIXEDFRAME);
				h += 2 * GetSystemMetrics (SM_CXFIXEDFRAME) + GetSystemMetrics (SM_CYCAPTION);

				if (x == -1 && y == -1)
				{
					x = (GetSystemMetrics (SM_CXSCREEN) - w) / 2;
					y = (GetSystemMetrics (SM_CYSCREEN) - h) / 2;
				}

				MoveWindow (hwnd, x, y, w, h, FALSE);

				EnumChildWindows (hwnd, SetControlFontProc, (LPARAM) gDlogFont);

				if (defctrl != NULL)
				{
					SetFocus (defctrl);
					return FALSE;
				}
				else
				{
					return TRUE;		/* allow windows to set focus;	*/
				}
			}
			break;
		case WM_SETFONT:
			{
				HFONT hfont;

				hfont = (HFONT) wParam;

				gDlogFont = hfont;
				return FALSE;	/* PA: added */
			}
			break;
		case WM_HSCROLL:		/* PA: new alternative to handle horizontal scrollbar actions. */
		case WM_VSCROLL:		/* PA: new alternative to handle vertical scrollbar actions. */
			{
				int nPos,nScrollCode;
				HWND hwndScrollBar;

				nScrollCode = LOWORD (wParam);

				if (nScrollCode != SB_ENDSCROLL)	/* Do not send the SB_ENDSCROLL to Clean. */
				{
					nPos = (short int) HIWORD (wParam);
					hwndScrollBar = (HWND) lParam;
					SendMessage5ToClean (CcWmSCROLLBARACTION, hwnd, hwndScrollBar, SB_CTL, nScrollCode, nPos);
				}
				return TRUE;	/* PA: added*/
			}
			break;
		case WM_DRAWITEM:
			{
				LPDRAWITEMSTRUCT lpdis;
				lpdis = (LPDRAWITEMSTRUCT) lParam;

				switch (lpdis->CtlType)
				{
					case ODT_COMBOBOX:
						{
							char text[256];
							COLORREF forecolor, bkcolor;
							SendMessage (lpdis->hwndItem, CB_GETLBTEXT, lpdis->itemID, (LPARAM) text);
							if (lpdis->itemState & ODS_DISABLED)
							{
								forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
								bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_3DFACE));
							}
							else if (lpdis->itemState & ODS_SELECTED)
							{
								if (lpdis->itemData)
								{
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_HIGHLIGHTTEXT));
									bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_HIGHLIGHT));
								}
								else
								{
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
									bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_WINDOW));
								}
							}
							else
							{
								if (lpdis->itemData)
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_WINDOWTEXT));
								else
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
								bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_WINDOW));
							}

							ExtTextOut (lpdis->hDC,					/* device context         */
										lpdis->rcItem.left + 2,		/* ref point x            */
										lpdis->rcItem.top + 1,		/* ref point y            */
										ETO_CLIPPED | ETO_OPAQUE,	/* options                */
										&lpdis->rcItem,				/* clipping rect          */
										text,						/* text to draw           */
										lstrlen (text),				/* length of text to draw */
										NULL						/* no kerning array       */
								);

							SetTextColor (lpdis->hDC, forecolor);
							SetBkColor (lpdis->hDC, bkcolor);

							if (lpdis->itemState & ODS_FOCUS)
								DrawFocusRect (lpdis->hDC, &lpdis->rcItem);

							return TRUE;	/* PA: added */
						} break;
					case ODT_BUTTON:
						{
							BOOL enabled;
							enabled = lpdis->itemState & ODS_DISABLED ? FALSE : TRUE;

							/* PA: less arguments are passed to Clean.
							SendMessage6ToClean (CcWmDRAWCONTROL, hwnd, lpdis->hwndItem, lpdis->hDC, lpdis->rcItem.left, lpdis->rcItem.top, enabled);
							*/
							SendMessage3ToClean (CcWmDRAWCONTROL, hwnd, lpdis->hwndItem, lpdis->hDC);
								 
							if (lpdis->itemState & ODS_SELECTED)
								InvertRect (lpdis->hDC, &lpdis->rcItem);
								
							if (lpdis->itemState & ODS_FOCUS)
								DrawFocusRect (lpdis->hDC, &lpdis->rcItem);
							return TRUE;	/* PA: added */
						} break;
				}
				return FALSE;		/* PA: added */
			}
			break;
		default:
			return FALSE;
			break;
	}
	ErrorExit ("Fatal error: case leak in DialogProcedure (%d).",message);
}

static LRESULT CALLBACK
MainWindowProcedure (HWND hWin, UINT uMess, WPARAM wPara, LPARAM lPara)
{
	printMessage ("Main Window", hWin, uMess, wPara, lPara);
	switch (uMess)
	{
		case WM_NCPAINT:
			break;
		case WM_ACTIVATEAPP:
			{
				if (wPara)
				{
					gAppRunning = TRUE;
				}
				else
				{
					gAppRunning = FALSE;
					SendMessage (ghMenuBarWindow, WM_NCACTIVATE, FALSE, 0);
				}
			}
			break;
		case WM_ENTERIDLE:
			{
				SendMessage0ToClean (CcWmIDLETIMER);
			} break;
		case WM_TIMER:
			{
				SendMessage2ToClean (CcWmTIMER, wPara, GetMessageTime ());
			}
			break;
		case WM_ACTIVATE:
			{
				if (LOWORD (wPara) != WA_INACTIVE)
				{
					ActivateTopWindow ();
				}
			}
			break;
		case WM_ENABLE:
			{
				HWND hwin;
				char title[64];

				hwin = GetWindow (ghMainWindow, GW_HWNDFIRST);
				while (hwin != NULL)
				{
					GetWindowText (hwin, title, 63);

					if (GetWindow (hwin, GW_OWNER) == ghMainWindow)
					{
						RECT r;
						GetWindowRect (hwin, &r);
						if (r.top != -1 || r.left != -1 || r.right != 0 || r.bottom != 0)
						{
							EnableWindow (hwin, (BOOL) wPara);
						}
					}
					hwin = GetWindow (hwin, GW_HWNDNEXT);
				}
			}
			break;
		case WM_DDE_INITIATE:
			{
				static char apptext[256], topictext[256];
				ATOM aApp, aTopic;
/* RWS ... */
				BOOL handleTopic;			// PA: added from Ronny
/* ... RWS */

				rprintf ("DDE_INITIATE: handle		 = %d\n", wPara);
				GlobalGetAtomName (HIWORD (lPara), topictext, 256);
				rprintf ("				topic		 = \"%s\"\n", topictext);

				if (lstrcmp (topictext, "CLEANOPEN") == 0)
/* RWS: compare application name */
				{
					GlobalGetAtomName (LOWORD (lPara), apptext, 256);
					rprintf ("				application  = \"%s\"\n", apptext);
					handleTopic	= CompareStringA (LOCALE_USER_DEFAULT, NORM_IGNORECASE,		// PA: added from Ronny up until next RWS
									apptext, lstrlen (apptext), gAppName, lstrlen (gAppName)) == 2;	/* 2 means they are equal */
				}
				else
					handleTopic	= FALSE;

				if (handleTopic)
				{
/* ... RWS */
					rprintf ("		   sending acknowledgement...\n");
					aApp = GlobalAddAtom (apptext);
					aTopic = GlobalAddAtom (topictext);
					SendMessage ((HWND) wPara, WM_DDE_ACK, (WPARAM) hWin, MAKELONG (aApp, aTopic));
					GlobalDeleteAtom (aApp);
					GlobalDeleteAtom (aTopic);
					rprintf ("			 acknowledgement sent.\n");
				}
				else
				{
					rprintf ("			wrong topic.\n", topictext);
					return DefWindowProc (hWin, uMess, wPara, lPara);
				}
			} break;
		case WM_DDE_EXECUTE:
			{
				char *commandstring;
				char *pcommand;
				int len;
				union
				{
					DDEACK ddeack;
					WORD w;
				}	da;

				rprintf ("DDE_EXCUTE: handle  = %d\n", wPara);
				pcommand = GlobalLock ((HANDLE) lPara);
				len = lstrlen (pcommand) + 1;
				commandstring = rmalloc (len);	/* this pointer is passed to,
												   and freed in, the clean
												   code. */
				lstrcpyn (commandstring, pcommand, len);
				GlobalUnlock ((HANDLE) lPara);
				rprintf ("			  command = \"%s\"\n", commandstring);

				rprintf ("		   executing command... \"");
				SendMessage1ToClean (CcWmDDEEXECUTE, commandstring);
				rprintf ("			 command executed.\n");

				rprintf ("		   sending acknowledgement...\n");
				da.ddeack.bAppReturnCode = 0;
				da.ddeack.fBusy = 0;
				da.ddeack.fAck = 1;
				PostMessage ((HWND) wPara,
							 WM_DDE_ACK,
							 (WPARAM) hWin,
							 PackDDElParam (WM_DDE_ACK, (UINT) da.w, lPara));
				rprintf ("			 acknowledgement sent.\n");
				return 0;
			} break;
		case WM_DDE_TERMINATE:
			{
				rprintf ("DDE_TERMINATE: handle  = %d\n", wPara);
				rprintf ("		   sending acknowledgement...\n");
				PostMessage ((HWND) wPara, WM_DDE_TERMINATE, (WPARAM) hWin, 0);
				rprintf ("			 acknowledgement sent.\n");
			} return 0;

		default:
			return DefWindowProc (hWin, uMess, wPara, lPara);
			break;
	}
	return 0;
}

static LRESULT CALLBACK
CustomControlProcedure (HWND hwnd, UINT uMess, WPARAM wParam, LPARAM lParam)
{
	printMessage ("CustomControlProcedure", hwnd, uMess, wParam, lParam);
	switch (uMess)
	{
		case WM_PAINT:
			{
				HWND parent;
				HDC hdc;
/*				BOOL enabled;						PA: not required anymore. */
				PAINTSTRUCT ps;

/*				parent = GetParent (hwnd);			PA: retrieve the top-most parent. */
				parent = GetParentWindow (hwnd);
/*				enabled = IsWindowEnabled (hwnd);	PA: not required anymore. */
				hdc = BeginPaint (hwnd, &ps);
				
/*				SendMessage6ToClean (CcWmDRAWCONTROL, parent, hwnd, hdc, 0, 0, enabled);	PA: less argument passed. */
				SendMessage3ToClean (CcWmDRAWCONTROL, parent, hwnd, hdc);
				
				EndPaint (hwnd, &ps);
				return 0;		/* PA: added */
			} break;
		case WM_LBUTTONDOWN:
			{
				SendMouseDownToClean (hwnd, SIGNEDLOWORD (lParam), SIGNEDHIWORD (lParam));
				return 0;		/* PA: added */
			} break;
		case WM_MOUSEMOVE:
			{
				if (gInMouseDown)
				{
					SendMouseStillDownToClean (hwnd, SIGNEDLOWORD (lParam), SIGNEDHIWORD (lParam));
				}
				else
				{
					SendMouseStillUpToClean (hwnd, SIGNEDLOWORD (lParam), SIGNEDHIWORD (lParam));
				}
				return 0;		/* PA: added */
			} break;
		case WM_LBUTTONUP:
			{
				if (gInMouseDown)
				{
					ReleaseCapture ();	/* rely on WM_CAPTURECHANGED to send the mouseUp event */
				}
				return 0;		/* PA: added */
			} break;
		case WM_CANCELMODE:
			{
				if (gInMouseDown)
				{
					ReleaseCapture ();	/* rely on WM_CAPTURECHANGED to send the mouseUp event */
				}
				return DefWindowProc (hwnd, uMess, wParam, lParam);
			} break;
		case WM_CAPTURECHANGED:
			{
				if (gInMouseDown)
				{
					POINT p;
					GetCursorPos (&p);
					ScreenToClient (hwnd, &p);
					SendMouseUpToClean (hwnd, p.x, p.y);
				}
				return 0;		/* PA: added */
			} break;
		/* PA: WM_ENTERIDLE message added. */
		case WM_ENTERIDLE:
			{
				SendMessage0ToClean (CcWmIDLETIMER);
				return 0;
			} break;
		case WM_TIMER:
			{
				if ((int) wParam == -1)
				{
					POINT p;
					GetCursorPos (&p);
					ScreenToClient (hwnd, &p);
					SendMouseStillDownToClean (hwnd, p.x, p.y);
				}
				else
				{
					rprintf ("Custom control did not expect normal WM_TIMER message with id = %d.\n", wParam);
				}
				return 0;		/* PA: added */
			} break;
		case WM_SYSKEYDOWN:
		case WM_KEYDOWN:
			{
				int c = 0;

				c = CheckVirtualKeyCode ((int) wParam);

				if (!c)
				/* Ignore non-virtual keys, because they arrive as WM_SYSCHAR and WM_CHAR. */
				{
					return DefWindowProc (hwnd, uMess, wParam, lParam);
				}
				/* Handle virtual keys analogously to keys received as WM_SYSCHAR and WM_CHAR. */
				if (gInKey)
				{
					if (gCurChar == c)
						SendKeyStillDownToClean (hwnd, gCurChar);
					else
					{
						SendKeyUpToClean (hwnd, gCurChar);
						gCurChar = c;
						SendKeyDownToClean (hwnd, gCurChar);
					}
				}
				else
				{
					gCurChar = c;
					SendKeyDownToClean (hwnd, gCurChar);
					gInKey = TRUE;
				}
				return 0;
			}
			break;
		case WM_SYSCHAR:
		case WM_CHAR:
			{
				if (gInKey)
				{
					if (gCurChar == (int) wParam)
						SendKeyStillDownToClean (hwnd, gCurChar);
					else
					{
						SendKeyUpToClean (hwnd, gCurChar);
						gCurChar = wParam;
						SendKeyDownToClean (hwnd, gCurChar);
					}
				}
				else
				{
					gCurChar = wParam;
					SendKeyDownToClean (hwnd, gCurChar);
					gInKey = TRUE;
				}
				return 0;		/* PA: added */
			}
			break;
		case WM_SYSKEYUP:
		case WM_KEYUP:
			{
				if (gInKey)
					SendKeyUpToClean (hwnd, gCurChar);
				gInKey = FALSE;
				return DefWindowProc (hwnd, uMess, wParam, lParam);
			}
			break;
		case WM_KILLFOCUS:
			{
				if (gInKey)
					SendKeyUpToClean (hwnd, gCurChar);
				gInKey = FALSE;
				return 0;		/* PA: added */
			}
			break;
		case WM_SETFOCUS:
			return 0;			/* PA: added */
			break;
		case WM_GETDLGCODE:		/* PA: inform dialog procedure to pass all keyboard input to the control. */
			return (DLGC_WANTCHARS | DLGC_WANTARROWS);
			break;
		default:
			return DefWindowProc (hwnd, uMess, wParam, lParam);
			break;
	}
	ErrorExit ("Fatal error: case leak in CustomControlProcedure (%d).",uMess);
}


/* PA: new event handler for compound controls. */
static LRESULT CALLBACK
CompoundControlProcedure (HWND hwnd, UINT uMess, WPARAM wParam, LPARAM lParam)
{
	printMessage ("CompoundControlProcedure", hwnd, uMess, wParam, lParam);
	switch (uMess)
	{
		case WM_COMMAND:		/* Analogous to DialogProcedure. */
			{
				switch (HIWORD (wParam))
				{
					case BN_CLICKED:
						{
							if (lParam != 0)
							{
								/* PA: modifiers are now also sent to Clean */
								SendMessage3ToClean (CcWmBUTTONCLICKED, GetParentWindow (hwnd), lParam, GetModifiers ());
							}
							return 0;		/* PA: added */
						}
						break;
					case CBN_SETFOCUS:
						{
							gComboSelection = SendMessage ((HWND) lParam, CB_GETCURSEL, 0, 0);
							return 0;		/* PA: added */
						}
						break;
					case CBN_KILLFOCUS:
						{
							gComboSelection = -1;
							return 0;		/* PA: added */
						}
						break;
					case CBN_SELENDOK:
						{
							char text[256];
							int newsel;
							HWND combo;

							combo = (HWND) lParam;
							newsel = SendMessage (combo, CB_GETCURSEL, 0, 0);
							SendMessage (combo, CB_GETLBTEXT, newsel, (LPARAM) text);
							if (!SendMessage (combo, CB_GETITEMDATA, newsel, 0))
							{
								SendMessage (combo, CB_SETCURSEL, gComboSelection, (LPARAM) text);
								MessageBeep (0xFFFFFFFF);
								return 0;
							}
							else
							{
								gComboSelection = newsel;
								SendMessage3ToClean (CcWmCOMBOSELECT, GetParentWindow (hwnd), combo, newsel);
								return DefWindowProc (hwnd, uMess, wParam, lParam);	/* PA: added */
							}
						}
						break;
				}
				return 0;	/* PA: added */
			} break;
		case WM_PAINT:
			{
				HWND parentwindow;
				HDC hdc;
				PAINTSTRUCT ps;

				parentwindow = GetParentWindow (hwnd);
				hdc = BeginPaint (hwnd, &ps);
				SendMessage3ToClean (CcWmDRAWCONTROL, parentwindow, hwnd, hdc);
				EndPaint (hwnd, &ps);
				return 0;		/* PA: added */
			} break;
		case WM_HSCROLL:		/* PA: new alternative to handle horizontal scrollbar actions. */
			{
				int nPos,nScrollCode,controlkind;
				HWND parentwindow, hwndScrollBar;

				nScrollCode = LOWORD (wParam);

				if (nScrollCode != SB_ENDSCROLL)	/* Do not send the SB_ENDSCROLL to Clean. */
				{
					nPos = (short int) HIWORD (wParam);
					parentwindow  = GetParentWindow (hwnd);
					hwndScrollBar = (HWND) lParam;

					if (hwndScrollBar==0)
					{
						controlkind = SB_HORZ;		/* lParam==0 in case of Compound scrollbars. */
						hwndScrollBar = hwnd;		/* pass the compound control handle to Clean. */
					}
					else
					{
						controlkind = SB_CTL;		/* lParam!==0 in case of SliderControls. */
					}
					SendMessage5ToClean (CcWmSCROLLBARACTION, parentwindow, hwndScrollBar, controlkind, nScrollCode, nPos);
				}
				return 0;		/* PA: added */
			}
			break;
		case WM_VSCROLL:		/* PA: new alternative to handle vertical scrollbar actions. */
			{
				int nPos,nScrollCode,controlkind;
				HWND parentwindow, hwndScrollBar;

				nScrollCode = LOWORD (wParam);

				if (nScrollCode != SB_ENDSCROLL)	/* Do not send the SB_ENDSCROLL to Clean. */
				{
					nPos = (short int) HIWORD (wParam);
					parentwindow  = GetParentWindow (hwnd);
					hwndScrollBar = (HWND) lParam;

					if (hwndScrollBar==0)
					{
						controlkind = SB_VERT;		/* lParam==0 in case of Compound scrollbars. */
						hwndScrollBar = hwnd;		/* pass the compound control handle to Clean. */
					}
					else
					{
						controlkind = SB_CTL;		/* lParam!==0 in case of SliderControls. */
					}
					SendMessage5ToClean (CcWmSCROLLBARACTION, parentwindow, hwndScrollBar, controlkind, nScrollCode, nPos);
				}
				return 0;		/* PA: added */
			}
			break;
		/* PA: the following cases concerning mouse events 
				(WM_LBUTTONDOWN upto WM_TIMER) have been copied from CustomControlProcedure. 
		*/
		case WM_LBUTTONDOWN:
			{
				SendMouseDownToClean (hwnd, SIGNEDLOWORD (lParam), SIGNEDHIWORD (lParam));
				return 0;		/* PA: added */
			} break;
		case WM_MOUSEMOVE:
			{
				if (gInMouseDown)
				{
					SendMouseStillDownToClean (hwnd, SIGNEDLOWORD (lParam), SIGNEDHIWORD (lParam));
				}
				else
				{
					SendMouseStillUpToClean (hwnd, SIGNEDLOWORD (lParam), SIGNEDHIWORD (lParam));
				}
				return 0;		/* PA: added */
			} break;
		case WM_LBUTTONUP:
			{
				if (gInMouseDown)
				{
					ReleaseCapture ();	/* rely on WM_CAPTURECHANGED to send the mouseUp event */
				}
				return 0;		/* PA: added */
			} break;
		case WM_CANCELMODE:
			{
				if (gInMouseDown)
				{
					ReleaseCapture ();	/* rely on WM_CAPTURECHANGED to send the mouseUp event */
				}
				return DefWindowProc (hwnd, uMess, wParam, lParam);
			} break;
		case WM_CAPTURECHANGED:
			{
				if (gInMouseDown)
				{
					POINT p;
					GetCursorPos (&p);
					ScreenToClient (hwnd, &p);
					SendMouseUpToClean (hwnd, p.x, p.y);
				}
				return 0;		/* PA: added */
			} break;
		/* PA: WM_ENTERIDLE message added. */
		case WM_ENTERIDLE:
			{
				SendMessage0ToClean (CcWmIDLETIMER);
				return 0;
			} break;
		case WM_TIMER:
			{
				if ((int) wParam == -1)
				{
					POINT p;
					GetCursorPos (&p);
					ScreenToClient (hwnd, &p);
					SendMouseStillDownToClean (hwnd, p.x, p.y);
				}
				else
				{
					rprintf ("Compound control did not expect normal WM_TIMER message with id = %d.\n", wParam);
				}
				return 0;		/* PA: added */
			} break;
		/* PA: The following cases concerning key events and focus events 
				(WM_SYSKEYDOWN upto WM_GETDLGCODE) have been copied from CustomControlProcedure.
		*/
		case WM_SYSKEYDOWN:
		case WM_KEYDOWN:
			{
				int c = 0;

				c = CheckVirtualKeyCode ((int) wParam);

				if (!c)
				/* Ignore non-virtual keys, because they arrive as WM_SYSCHAR and WM_CHAR. */
				{
					return DefWindowProc (hwnd, uMess, wParam, lParam);
				}
				/* Handle virtual keys analogously to keys received as WM_SYSCHAR and WM_CHAR. */
				if (gInKey)
				{
					if (gCurChar == c)
						SendKeyStillDownToClean (hwnd, gCurChar);
					else
					{
						SendKeyUpToClean (hwnd, gCurChar);
						gCurChar = c;
						SendKeyDownToClean (hwnd, gCurChar);
					}
				}
				else
				{
					gCurChar = c;
					SendKeyDownToClean (hwnd, gCurChar);
					gInKey = TRUE;
				}
				return 0;
			}
			break;
		case WM_SYSCHAR:
		case WM_CHAR:
			{
				if (gInKey)
				{
					if (gCurChar == (int) wParam)
						SendKeyStillDownToClean (hwnd, gCurChar);
					else
					{
						SendKeyUpToClean (hwnd, gCurChar);
						gCurChar = wParam;
						SendKeyDownToClean (hwnd, gCurChar);
					}
				}
				else
				{
					gCurChar = wParam;
					SendKeyDownToClean (hwnd, gCurChar);
					gInKey = TRUE;
				}
				return 0;		/* PA: added */
			}
			break;
		case WM_SYSKEYUP:
		case WM_KEYUP:
			{
				if (gInKey)
					SendKeyUpToClean (hwnd, gCurChar);
				gInKey = FALSE;
				return DefWindowProc (hwnd, uMess, wParam, lParam);
			}
			break;
		case WM_KILLFOCUS:
			{
				if (gInKey)
					SendKeyUpToClean (hwnd, gCurChar);
				gInKey = FALSE;
				return 0;		/* PA: added */
			}
			break;
		case WM_SETFOCUS:
			return 0;			/* PA: added */
			break;
		case WM_GETDLGCODE:		/* PA: inform dialog procedure to pass all keyboard input to the control. */
			return (DLGC_WANTCHARS | DLGC_WANTARROWS);
			break;
		case WM_DRAWITEM:		/* Analogous to DialogProcedure. */
			{
				LPDRAWITEMSTRUCT lpdis;
				lpdis = (LPDRAWITEMSTRUCT) lParam;

				switch (lpdis->CtlType)
				{
					case ODT_COMBOBOX:
						{
							char text[256];
							COLORREF forecolor, bkcolor;
							SendMessage (lpdis->hwndItem, CB_GETLBTEXT, lpdis->itemID, (LPARAM) text);
							if (lpdis->itemState & ODS_DISABLED)
							{
								forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
								bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_3DFACE));
							}
							else if (lpdis->itemState & ODS_SELECTED)
							{
								if (lpdis->itemData)
								{
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_HIGHLIGHTTEXT));
									bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_HIGHLIGHT));
								}
								else
								{
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
									bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_WINDOW));
								}
							}
							else
							{
								if (lpdis->itemData)
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_WINDOWTEXT));
								else
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
								bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_WINDOW));
							}

							ExtTextOut (lpdis->hDC,					/* device context         */
										lpdis->rcItem.left + 2,		/* ref point x            */
										lpdis->rcItem.top + 1,		/* ref point y            */
										ETO_CLIPPED | ETO_OPAQUE,	/* options                */
										&lpdis->rcItem,				/* clipping rect          */
										text,						/* text to draw           */
										lstrlen (text),				/* length of text to draw */
										NULL						/* no kerning array       */
								);

							SetTextColor (lpdis->hDC, forecolor);
							SetBkColor (lpdis->hDC, bkcolor);

							if (lpdis->itemState & ODS_FOCUS)
								DrawFocusRect (lpdis->hDC, &lpdis->rcItem);
							return 0;		/* PA: added */
						} break;
					case ODT_BUTTON:
						{
							BOOL enabled;
							HWND parentwindow;

							enabled = lpdis->itemState & ODS_DISABLED ? FALSE : TRUE;
							parentwindow  = GetParentWindow (hwnd);

							SendMessage3ToClean (CcWmDRAWCONTROL, parentwindow, lpdis->hwndItem, lpdis->hDC);
							 
							if (lpdis->itemState & ODS_SELECTED)
								InvertRect (lpdis->hDC, &lpdis->rcItem);
							
							if (lpdis->itemState & ODS_FOCUS)
								DrawFocusRect (lpdis->hDC, &lpdis->rcItem);
							return 0;	/* PA: added */
						} break;
				}
				return 0;		/* PA: added*/
			}
			break;
		default:
			return DefWindowProc (hwnd, uMess, wParam, lParam);
			break;
	}
	ErrorExit ("Fatal error: case leak in CompoundControlProcedure (%d).",uMess);
}
/* PA: end of new event handler for CompoundControls. */


/*	PA: new event handler for subclassing edit controls. 
	This routine catches all keyboard input and handles it as a standard windows edit control would, but in addition
	it also sends each keyboard input to Clean.
	All other events are handled as a standard windows edit control. 
*/
static LRESULT CALLBACK
EditControlProcedure (HWND hwnd,UINT uMess,WPARAM wParam,LPARAM lParam)
{
	LRESULT stdresult;

	printMessage ("Clean Edit Control", hWin, uMess, wParam, lParam);

	/* First preprocess all messages as if you are a standard Windows edit control. */
	stdresult = CallWindowProc ((WNDPROC) stdEditCallback, hwnd, uMess, wParam, lParam);

	switch (uMess)
	{
		case WM_SYSKEYDOWN:
		case WM_KEYDOWN:
			{
				int c = 0;

				c = CheckVirtualKeyCode ((int) wParam);

				if (!c)
				/* Ignore non-virtual keys, because they arrive as WM_SYSCHAR and WM_CHAR. */
				{
					return stdresult;
				}
				/* Handle virtual keys analogously to keys received as WM_SYSCHAR and WM_CHAR. */
				if (gInKey)
				{
					if (gCurChar == c)
						SendKeyStillDownToClean (hwnd, gCurChar);
					else
					{
						SendKeyUpToClean (hwnd, gCurChar);
						gCurChar = c;
						SendKeyDownToClean (hwnd, gCurChar);
					}
				}
				else
				{
					gCurChar = c;
					SendKeyDownToClean (hwnd, gCurChar);
					gInKey = TRUE;
				}
				return stdresult;
			}
			break;
		case WM_SYSCHAR:
		case WM_CHAR:
			{
				if (gInKey)
				{
					if (gCurChar == (int) wParam)
						SendKeyStillDownToClean (hwnd, gCurChar);
					else
					{
						SendKeyUpToClean (hwnd, gCurChar);
						gCurChar = wParam;
						SendKeyDownToClean (hwnd, gCurChar);
					}
				}
				else
				{
					gCurChar = wParam;
					SendKeyDownToClean (hwnd, gCurChar);
					gInKey = TRUE;
				}
				return stdresult;
			}
			break;
		case WM_SYSKEYUP:
		case WM_KEYUP:
			{
				if (gInKey)
					SendKeyUpToClean (hwnd, gCurChar);
				gInKey = FALSE;
				return stdresult;
			}
			break;
		case WM_KILLFOCUS:
			{
				if (gInKey)
					SendKeyUpToClean (hwnd, gCurChar);
				gInKey = FALSE;
				return stdresult;
			}
			break;
	}
	
	/* PA: in addition to keyboard input also send idle timer events to clean. 
			Necessary to cause timers and receivers handle events.
	*/
	if (gIdleTimerOn)
		SendMessage0ToClean (CcWmIDLETIMER);

	return stdresult;
}
/* PA: end of new event handler for subclassing edit controls. */


static LRESULT CALLBACK
CleanWindowProcedure (HWND hWin,UINT uMess,WPARAM wPara,LPARAM lPara)
{
	printMessage ("Clean Doc Window", hWin, uMess, wPara, lPara);

	switch (uMess)
	{
		/* PA: copied from CompoundControlProcedure. So this is IDENTICAL code (except for names hWin)*/
		case WM_COMMAND:		/* Analogous to DialogProcedure. */
			{
				switch (HIWORD (wPara))
				{
					case BN_CLICKED:
						{
							if (lPara != 0)
							{
								/* PA: modifiers are now also sent to Clean */
								SendMessage3ToClean (CcWmBUTTONCLICKED, GetParentWindow (hWin), lPara, GetModifiers ());
							}
						}
						break;
					case CBN_SETFOCUS:
						{
							gComboSelection = SendMessage ((HWND) lPara, CB_GETCURSEL, 0, 0);
						}
						break;
					case CBN_KILLFOCUS:
						{
							gComboSelection = -1;
						}
						break;
					case CBN_SELENDOK:
						{
							char text[256];
							int newsel;
							HWND combo;

							combo = (HWND) lPara;
							newsel = SendMessage (combo, CB_GETCURSEL, 0, 0);
							SendMessage (combo, CB_GETLBTEXT, newsel, (LPARAM) text);
							if (!SendMessage (combo, CB_GETITEMDATA, newsel, 0))
							{
								SendMessage (combo, CB_SETCURSEL, gComboSelection, (LPARAM) text);
								MessageBeep (0xFFFFFFFF);
								return TRUE;
							}
							else
							{
								gComboSelection = newsel;
								SendMessage3ToClean (CcWmCOMBOSELECT, GetParentWindow (hWin), combo, newsel);
								return FALSE;
							}
						}
						break;
				}
			} break;
		/* PA: end of copy from CompoundControlProcedure. */
		case WM_ENTERMENULOOP:
			{
				gProhibitWindowActivation++;
			} break;
		case WM_EXITMENULOOP:
			{
				gProhibitWindowActivation--;
			} break;
		case WM_SETCURSOR:
			{
				int cursorcode;

				if (gGlobalCursorCode == -1)
				{
					if ((HWND) wPara != hWin || LOWORD (lPara) != HTCLIENT)
					{
						return DefWindowProc (hWin, uMess, wPara, lPara);
					}
					SendMessage1ToClean (CcWmSETCURSOR, hWin);
					cursorcode = gCci.p1;
				}
				else
				{
					cursorcode = gGlobalCursorCode;
				}

				SetCursorFromCode (cursorcode);
			}
			break;
		/* PA: previous implementation of WM_PAINT.
		case WM_PAINT:
			{
				RECT updaterect;

				if (!GetUpdateRect (hWin, &updaterect, FALSE))
					GetClientRect (hWin, &updaterect);

				SendMessage5ToClean (CcWmPAINT, hWin, updaterect.left,
									 updaterect.top,
									 updaterect.right,
									 updaterect.bottom);
			}
			break;
		PA: end of previous implementation. */
		case WM_PAINT:	/* hwnd;	   no return value. */
			{
				RECT updaterect;
				HDC  hdc;
				PAINTSTRUCT ps;

				if (GetUpdateRect (hWin, &updaterect, FALSE))
				{
					hdc = BeginPaint (hWin, &ps);
					SendMessage6ToClean (CcWmPAINT, hWin, updaterect.left,updaterect.top,updaterect.right,updaterect.bottom,hdc);
					EndPaint (hWin, &ps);
				}
				else
				{	
					GetClientRect (hWin, &updaterect);
					SendMessage6ToClean (CcWmPAINT, hWin, updaterect.left,
									 updaterect.top,
									 updaterect.right,
									 updaterect.bottom,wPara);
				}
			}
			break;
		case WM_SYSCHAR:
		case WM_CHAR:
			{
				if (gInKey)
				{
					if (gCurChar == (int) wPara)
						SendKeyStillDownToClean (hWin, gCurChar);
					else
					{
						SendKeyUpToClean (hWin, gCurChar);
						gCurChar = wPara;
						SendKeyDownToClean (hWin, gCurChar);
					}
				}
				else
				{
					gCurChar = wPara;
					SendKeyDownToClean (hWin, gCurChar);
					gInKey = TRUE;
				}
			}
			break;
		case WM_SYSKEYUP:
		case WM_KEYUP:
			{
				if (gInKey)
					SendKeyUpToClean (hWin, gCurChar);
				gInKey = FALSE;
				return (DefWindowProc (hWin, uMess, wPara, lPara));
			}
			break;
		case WM_KILLFOCUS:
			{
				if (gInKey)
					SendKeyUpToClean (hWin, gCurChar);
				gInKey = FALSE;
			}
			break;

		case WM_LBUTTONDOWN:
			{
				SendMouseDownToClean (hWin, SIGNEDLOWORD (lPara), SIGNEDHIWORD (lPara));
			}
			break;
		case WM_MOUSEMOVE:
			{
				if (gInMouseDown)
				{
					SendMouseStillDownToClean (hWin, SIGNEDLOWORD (lPara), SIGNEDHIWORD (lPara));
				}
				else
				{
					SendMouseStillUpToClean (hWin, SIGNEDLOWORD (lPara), SIGNEDHIWORD (lPara));
				}
			}
			break;
		case WM_LBUTTONUP:
			{
				if (gInMouseDown)
				{
					ReleaseCapture ();	/* rely on WM_CAPTURECHANGED to send
										   the mouseUp event */
				}
			}
			break;
		case WM_CANCELMODE:
			{
				if (gInMouseDown)
				{
					ReleaseCapture ();	/* rely on WM_CAPTURECHANGED to send
										   the mouseUp event */
				}
				return DefWindowProc (hWin, uMess, wPara, lPara);
			}
			break;
		case WM_CAPTURECHANGED:
			{
				if (gInMouseDown)
				{
					POINT p;
					GetCursorPos (&p);
					ScreenToClient (hWin, &p);
					SendMouseUpToClean (hWin, p.x, p.y);
				}
			}
			break;
		/* PA: WM_ENTERIDLE message added. */
		case WM_ENTERIDLE:
			{
				SendMessage0ToClean (CcWmIDLETIMER);
			}
			break;
		case WM_TIMER:
			{
				if ((int) wPara == -1)
				{
					POINT p;
					GetCursorPos (&p);
					ScreenToClient (hWin, &p);
					SendMouseStillDownToClean (hWin, p.x, p.y);
				}
				else
				{
					rprintf ("Clean Window did not expect normal WM_TIMER message with id = %d.\n", wPara);
				}
			}
			break;
		case WM_CLOSE:
			{
				SendMessage1ToClean (CcWmCLOSE, hWin);
			}
			break;
		case WM_ACTIVATEAPP:
			{
				if (ghTopDocWindow == hWin)
					if (wPara)
					{
						SendActivateToClean (hWin);
					}
					else
					{
						SendDeactivateToClean (hWin);
					};
				return DefWindowProc (hWin, uMess, wPara, lPara);
			}
			break;
		/* PA: previous implementation of WM_ACTIVATE: 
		case WM_ACTIVATE:
			{
				static HWND deactivatedwindow = NULL;
				if (LOWORD (wPara) != WA_INACTIVE && ghTopDocWindow != hWin)
				{
					SendDeactivateToClean (deactivatedwindow);
					SendActivateToClean (hWin);
					ghTopDocWindow = hWin;
				}
				else if (LOWORD (wPara) == WA_INACTIVE && ghTopDocWindow == hWin)
				{
					deactivatedwindow = ghTopDocWindow;
					ghTopDocWindow = NULL;
				}
				AdjustMenuBarName ();
				return DefWindowProc (hWin, uMess, wPara, lPara);
			}
			break;
		PA: end of previous implementation. */
		case WM_ACTIVATE:
			{
				if (LOWORD (wPara) != WA_INACTIVE && ghTopDocWindow != hWin)
				{
					SendActivateToClean (hWin);
					ghTopDocWindow = hWin;
				}
				else if (LOWORD (wPara) == WA_INACTIVE && ghTopDocWindow == hWin)
				{
					SendDeactivateToClean (hWin);
					ghTopDocWindow = NULL;
				}
				AdjustMenuBarName ();
				return DefWindowProc (hWin, uMess, wPara, lPara);
			}
			break;
		case WM_SYSCOMMAND:
			if (wPara == SC_KEYMENU)
			{
				SendMessage (ghMenuBarWindow, uMess, wPara, lPara);
			}
			else
			{
				return DefWindowProc (hWin, uMess, wPara, lPara);
			}
			break;
		case WM_CREATE:
			{
				LOGFONT lf;		// New
				HFONT hf;		// New

				SendMessage1ToClean (CcWmCREATE, hWin);

				/* PA: After creation of the window controls, their HFONT should be set to 8pt "MS Sans Serif" */
				SetLogFontData (&lf, "MS Sans Serif", 0, 8);
				hf = CreateFontIndirect (&lf);
				gWinFont = hf;
				EnumChildWindows (hWin, SetControlFontProc, (LPARAM) gWinFont);
				/* PA: End of addition. */
			}
			break;
		/* PA: previous implementation of WM_SIZING.
		case WM_SIZING:
			{
				POINT maxwinsize, curtracksize, maxtracksize, correction;
				LPRECT ptrackrect;

				if (!GetMinMaxInfoFromClean (hWin, &maxwinsize, NULL))
					return DefWindowProc (hWin, uMess, wPara, lPara);

				W95AdjustScrollWindowDimensions (&maxwinsize);

				ptrackrect = (LPRECT) lPara;
				curtracksize.x = ptrackrect->right - ptrackrect->left;
				curtracksize.y = ptrackrect->bottom - ptrackrect->top;

				if (curtracksize.y < maxwinsize.y)
					maxtracksize.x = maxwinsize.x + GetSystemMetrics (SM_CXVSCROLL);
				else
					maxtracksize.x = maxwinsize.x;

				if (curtracksize.x < maxwinsize.x)
					maxtracksize.y = maxwinsize.y + GetSystemMetrics (SM_CYHSCROLL);
				else
					maxtracksize.y = maxwinsize.y;

				if (curtracksize.x > maxtracksize.x)
					correction.x = curtracksize.x - maxtracksize.x;
				else
					correction.x = 0;

				if (curtracksize.y > maxtracksize.y)
					correction.y = curtracksize.y - maxtracksize.y;
				else
					correction.y = 0;

				switch (wPara)
				{
					case WMSZ_LEFT:
					case WMSZ_TOPLEFT:
					case WMSZ_BOTTOMLEFT:
						ptrackrect->left += correction.x;
						break;

					case WMSZ_RIGHT:
					case WMSZ_TOPRIGHT:
					case WMSZ_BOTTOMRIGHT:
					case WMSZ_TOP:
					case WMSZ_BOTTOM:
						ptrackrect->right -= correction.x;
						break;
				}

				switch (wPara)
				{
					case WMSZ_TOP:
					case WMSZ_TOPLEFT:
					case WMSZ_TOPRIGHT:
						ptrackrect->top += correction.y;
						break;
					case WMSZ_BOTTOM:
					case WMSZ_BOTTOMLEFT:
					case WMSZ_BOTTOMRIGHT:
					case WMSZ_LEFT:
					case WMSZ_RIGHT:
						ptrackrect->bottom -= correction.y;
						break;
				}

			}
			return TRUE;
		PA: end of previous implementation of WM_SIZING. */
		/* PA: WM_SIZING is now handled by the DefaultWindowProcedure. */
		/* PA: previous implementation of WM_SIZE
		case WM_SIZE:
			if (wPara != SIZE_MAXHIDE && wPara != SIZE_MAXSHOW)
			{
				SCROLLINFO hsif, vsif;
				POINT winmax, newsize, barsize, givensize;
				BOOL hadhbar, hadvbar, hasHScroll, hasVScroll;

				if (gInWMSIZE)
				{
					return DefWindowProc (hWin, uMess, wPara, lPara);
				}
				else
				{
					gInWMSIZE = TRUE;
				}

				if (!GetMinMaxInfoFromClean (hWin, &winmax, NULL))
				{
					gInWMSIZE = FALSE;
					return DefWindowProc (hWin, uMess, wPara, lPara);
				}

				barsize.x = GetSystemMetrics (SM_CXVSCROLL);
				barsize.y = GetSystemMetrics (SM_CYHSCROLL);

				hsif.cbSize = sizeof (SCROLLINFO);
				vsif.cbSize = sizeof (SCROLLINFO);
				hsif.fMask = SIF_ALL;
				vsif.fMask = SIF_ALL;
				hasHScroll = GetScrollInfo (hWin, SB_HORZ, &hsif);
				hasVScroll = GetScrollInfo (hWin, SB_VERT, &vsif);

				hadhbar = (int) hsif.nPage < hsif.nMax - hsif.nMin;
				hadvbar = (int) vsif.nPage < vsif.nMax - vsif.nMin;

				givensize.x = SIGNEDLOWORD (lPara);
				givensize.y = SIGNEDHIWORD (lPara);

				// pretend there were scrollbars previously 
				if (!hadvbar)
					givensize.x -= barsize.x;
				if (!hadhbar)
					givensize.y -= barsize.y;

				newsize.x = givensize.x;
				newsize.y = givensize.y;

				// we may have gotten faulty clientsize info from windows 
				if (givensize.x >= winmax.x)					// PA: windows can be larger than winmax 
					newsize.y += barsize.x;
				else if (givensize.y >= winmax.y)				// PA: windows can be larger than winmax 
					newsize.x += barsize.y;
				else if (givensize.x + barsize.x >= winmax.x &&	// PA: windows can be larger than winmax 
						 givensize.y + barsize.y >= winmax.y)	// PA: windows can be larger than winmax 
				{
					newsize.x += barsize.x;
					newsize.y += barsize.y;
				}

				hsif.nPage = newsize.x;
				if (hsif.nPos + newsize.x > hsif.nMax + 1)
				{

					ScrollWindowEx (hWin, hsif.nPos + newsize.x - (hsif.nMax + 1), 0, NULL, NULL, NULL, NULL, SW_INVALIDATE);
					hsif.nPos = hsif.nMax + 1 - newsize.x;

					if (hasHScroll)								// PA: only if has hor.scrollbar, send new thumb. 
					{
						SendMessage2ToClean (CcWmNEWHTHUMB, hWin, hsif.nPos);
					}
				}
				if (hasHScroll)									// PA: only if has hor.scrollbar, redraw settings. 
				{
					SetScrollInfo (hWin, SB_HORZ, &hsif, TRUE);
				}

				vsif.nPage = newsize.y;
				if (vsif.nPos + newsize.y > vsif.nMax + 1)
				{
					ScrollWindowEx (hWin, 0, vsif.nPos + newsize.y - (vsif.nMax + 1), NULL, NULL, NULL, NULL, SW_INVALIDATE);
					vsif.nPos = vsif.nMax + 1 - newsize.y;

					if (hasVScroll)								// PA: only if has vert.scrollbar, send new thumb. 
					{
						SendMessage2ToClean (CcWmNEWVTHUMB, hWin, vsif.nPos);
					}
				}
				if (hasVScroll)									// PA: only if has vert.scrollbar, redraw settings. 
				{
					SetScrollInfo (hWin, SB_VERT, &vsif, TRUE);
				}

				gInWMSIZE = FALSE;
			}
			break;
		PA: end of previous implementation of WM_SIZE */
		/* PA: Now we only tell Clean about the resize action. */
		case WM_SIZE:
			if (wPara != SIZE_MAXHIDE && wPara != SIZE_MAXSHOW)
			{
				int width,height;

				width  = SIGNEDLOWORD (lPara);		// Width  of window excluding vertical scrollbar 
				height = SIGNEDHIWORD (lPara);		// Height of window excluding horizontal scrollbar 
				SendMessage3ToClean (CcWmSIZE, hWin, width, height);
			}
			break;
		/* PA: previous implementation of WM_HSCROLL.
		case WM_HSCROLL:
			{
				SCROLLINFO sif;
				int scrollline;
				int oldpos;
				BOOL didscroll;

				SendMessage1ToClean (CcWmGETHSCROLLVAL, hWin);
				scrollline = gCci.p1;

				sif.cbSize = sizeof (SCROLLINFO);
				sif.fMask = SIF_ALL;
				if (!GetScrollInfo (hWin, SB_HORZ, &sif))
					rprintf (":: WM_HSCROLL :: That bloody GetScrollInfo is at it again...\n");

				oldpos = sif.nPos;
				switch (LOWORD (wPara))
				{
					case SB_LINELEFT:
						sif.nPos -= scrollline;
						didscroll = TRUE;
						break;
					case SB_LINERIGHT:
						sif.nPos += scrollline;
						didscroll = TRUE;
						break;
					case SB_PAGELEFT:
						sif.nPos -= (int) sif.nPage - scrollline;
						didscroll = TRUE;
						break;
					case SB_PAGERIGHT:
						sif.nPos += sif.nPage - scrollline;
						didscroll = TRUE;
						break;
					case SB_THUMBPOSITION:
						sif.nPos = (short int) HIWORD (wPara);
						didscroll = TRUE;
						break;
					case SB_THUMBTRACK:
						sif.nPos = (short int) HIWORD (wPara);
						didscroll = TRUE;
						break;
					default:
						didscroll = FALSE;
				}

				if (didscroll)
				{
					sif.fMask = SIF_POS;
					SetScrollInfo (hWin, SB_HORZ, &sif, TRUE);

					GetScrollInfo (hWin, SB_HORZ, &sif);
					if (sif.nPos != oldpos)
					{
						ScrollWindowEx (hWin, oldpos - sif.nPos, 0, NULL, NULL, NULL, NULL, SW_INVALIDATE);
						SendMessage2ToClean (CcWmNEWHTHUMB, hWin, sif.nPos);
					}
				}

			}
			break;
		PA: end of previous implementation. */
		case WM_HSCROLL:		/* PA: version taken from CompoundControlProcedure. */
			{
				int nPos,nScrollCode,controlkind;
				HWND hwndScrollBar;

				nScrollCode = LOWORD (wPara);

				if (nScrollCode != SB_ENDSCROLL)	/* Do not send the SB_ENDSCROLL to Clean. */
				{
					nPos = (short int) HIWORD (wPara);
					hwndScrollBar = (HWND) lPara;

					if (hwndScrollBar==0)
					{
						controlkind = SB_HORZ;		/* lPara==0 in case of Window scrollbars. */
						hwndScrollBar = hWin;		/* pass the compound control handle to Clean. */
					}
					else
					{
						controlkind = SB_CTL;		/* lPara!=0 in case of SliderControls. */
					}
					SendMessage5ToClean (CcWmSCROLLBARACTION, hWin, hwndScrollBar, controlkind, nScrollCode, nPos);
				}
			}
			break;
		/* PA: previous implementation of WM_VSCROLL.
		case WM_VSCROLL:
			{
				SCROLLINFO sif;
				int scrollline;
				int oldpos;
				BOOL didscroll;

				SendMessage1ToClean (CcWmGETVSCROLLVAL, hWin);
				scrollline = gCci.p1;

				sif.cbSize = sizeof (SCROLLINFO);
				sif.fMask = SIF_ALL;
				if (!GetScrollInfo (hWin, SB_VERT, &sif))
					rprintf (":: WM_HSCROLL :: That bloody GetScrollInfo is at it again...\n");

				oldpos = sif.nPos;
				switch (LOWORD (wPara))
				{
					case SB_LINEUP:
						sif.nPos -= scrollline;
						didscroll = TRUE;
						break;
					case SB_LINEDOWN:
						sif.nPos += scrollline;
						didscroll = TRUE;
						break;
					case SB_PAGEUP:
						sif.nPos -= (int) sif.nPage - scrollline;
						didscroll = TRUE;
						break;
					case SB_PAGEDOWN:
						sif.nPos += sif.nPage - scrollline;
						didscroll = TRUE;
						break;
					case SB_THUMBPOSITION:
						sif.nPos = (short int) HIWORD (wPara);
						didscroll = TRUE;
						break;
					case SB_THUMBTRACK:
						sif.nPos = (short int) HIWORD (wPara);
						didscroll = TRUE;
						break;
					default:
						didscroll = FALSE;
				}

				if (didscroll)
				{
					sif.fMask = SIF_POS;
					SetScrollInfo (hWin, SB_VERT, &sif, TRUE);

					GetScrollInfo (hWin, SB_VERT, &sif);
					if (sif.nPos != oldpos)
					{
						ScrollWindowEx (hWin, 0, oldpos - sif.nPos, NULL, NULL, NULL, NULL, SW_INVALIDATE);

						SendMessage2ToClean (CcWmNEWVTHUMB, hWin, sif.nPos);
					}
				}

			}
			break;
		PA: end of previous implementation. */
		case WM_VSCROLL:		/* PA: version taken from CompoundControlProcedure. */
			{
				int nPos,nScrollCode,controlkind;
				HWND hwndScrollBar;

				nScrollCode = LOWORD (wPara);

				if (nScrollCode != SB_ENDSCROLL)	/* Do not send the SB_ENDSCROLL to Clean. */
				{
					nPos = (short int) HIWORD (wPara);
					hwndScrollBar = (HWND) lPara;

					if (hwndScrollBar==0)
					{
						controlkind = SB_VERT;		/* lPara==0 in case of Window scrollbars. */
						hwndScrollBar = hWin;		/* pass the window handle to Clean. */
					}
					else
					{
						controlkind = SB_CTL;		/* lPara!=0 in case of SliderControls. */
					}
					SendMessage5ToClean (CcWmSCROLLBARACTION, hWin, hwndScrollBar, controlkind, nScrollCode, nPos);
				}
			}
			break;
		/* PA: previous implementation of WM_GETMINMAXINFO.
		case WM_GETMINMAXINFO:
			{
				LPMINMAXINFO pmmi;
				POINT minsize, maxsize;

				pmmi = (LPMINMAXINFO) lPara;

				if (!GetMinMaxInfoFromClean (hWin, &maxsize, &minsize))
				{		// fixed window 
					WinMinimumWinSize ((int *) &(pmmi->ptMinTrackSize.x), (int *) &(pmmi->ptMinTrackSize.y));
				}
				else
				{		// scroll window 

					pmmi->ptMinTrackSize.x = minsize.x;
					pmmi->ptMinTrackSize.y = minsize.y;

					if (minsize.x < maxsize.x)
						pmmi->ptMinTrackSize.x += GetSystemMetrics (SM_CXVSCROLL);
					if (minsize.y < maxsize.y)
						pmmi->ptMinTrackSize.y += GetSystemMetrics (SM_CYHSCROLL);

					W95AdjustScrollWindowDimensions (&(pmmi->ptMinTrackSize));
				}
			}
			break;
		PA: end of previous implementation. */
		/* But what happens if we simply ignore this message??
		case WM_GETMINMAXINFO:		// Nowadays we are only interested in a minimum window size. 
			{
				LPMINMAXINFO pmmi;
				POINT minsize;

				pmmi = (LPMINMAXINFO) lPara;

				if (GetMinMaxInfoFromClean (hWin, NULL, &minsize))
				{	// resizable window with minimum size.
					pmmi->ptMinTrackSize.x = minsize.x;
					pmmi->ptMinTrackSize.y = minsize.y;
					W95AdjustScrollWindowDimensions (&(pmmi->ptMinTrackSize));
				}
			}
			break;
		*/
		case WM_DESTROY:
			{
				if (hWin == ghTopDocWindow)
				{
					rprintf ("CleanDocWindow WM_DESTROY: Setting ghTopDocWindow to NULL\n", hWin);
					ghTopDocWindow = NULL;
					AdjustMenuBarName ();
				}
			} break;
		/* PA: copied from CompoundControlProcedure (so this is IDENTICAL except for names of hWin and lPara): */
		case WM_DRAWITEM:		/* Analogous to DialogProcedure. */
			{
				LPDRAWITEMSTRUCT lpdis;
				lpdis = (LPDRAWITEMSTRUCT) lPara;

				switch (lpdis->CtlType)
				{
					case ODT_COMBOBOX:
						{
							char text[256];
							COLORREF forecolor, bkcolor;
							SendMessage (lpdis->hwndItem, CB_GETLBTEXT, lpdis->itemID, (LPARAM) text);
							if (lpdis->itemState & ODS_DISABLED)
							{
								forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
								bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_3DFACE));
							}
							else if (lpdis->itemState & ODS_SELECTED)
							{
								if (lpdis->itemData)
								{
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_HIGHLIGHTTEXT));
									bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_HIGHLIGHT));
								}
								else
								{
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
									bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_WINDOW));
								}
							}
							else
							{
								if (lpdis->itemData)
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_WINDOWTEXT));
								else
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
								bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_WINDOW));
							}

							ExtTextOut (lpdis->hDC, 	/* device context */
										lpdis->rcItem.left + 2, /* ref point x */
										lpdis->rcItem.top + 1,	/* ref point y */
										ETO_CLIPPED | ETO_OPAQUE,		/* options */
										&lpdis->rcItem, /* clipping rect */
										text,	/* text to draw */
										lstrlen (text), /* length of text to
														   draw */
										NULL	/* no kerning array */
								);

							SetTextColor (lpdis->hDC, forecolor);
							SetBkColor (lpdis->hDC, bkcolor);

							if (lpdis->itemState & ODS_FOCUS)
								DrawFocusRect (lpdis->hDC, &lpdis->rcItem);

						} break;
					case ODT_BUTTON:
						{
							{
								BOOL enabled;
								HWND parentwindow;

								enabled = lpdis->itemState & ODS_DISABLED ? FALSE : TRUE;
								parentwindow  = GetParentWindow (hWin);

								SendMessage3ToClean (CcWmDRAWCONTROL, parentwindow, lpdis->hwndItem, lpdis->hDC);
								 
								if (lpdis->itemState & ODS_SELECTED)
									InvertRect (lpdis->hDC, &lpdis->rcItem);
								
								if (lpdis->itemState & ODS_FOCUS)
									DrawFocusRect (lpdis->hDC, &lpdis->rcItem);
							};
							return TRUE;	/* PA: added */
						} break;
				}
			} break;
		/* PA: end of copy from CompoundControlProcedure. */
		default:
			return DefWindowProc (hWin, uMess, wPara, lPara);
			break;
	}
	return 0;
}

static BOOL
RbrtTranslateMessage (MSG * pmsg)
{
	int c;
	UINT msg;

	c   = 0;
	msg = pmsg->message;
	if (msg==WM_SYSKEYDOWN || msg==WM_KEYDOWN)
	{
		c = CheckVirtualKeyCode ((int) pmsg->wParam);
	}
	if (c)
	{
		gStoredMess = *pmsg;
		gStoredMess.wParam = (WPARAM) c;

		if (pmsg->message == WM_SYSKEYDOWN)
			gStoredMess.message = WM_SYSCHAR;
		else
			gStoredMess.message = WM_CHAR;

		gMessStored = TRUE;
		return TRUE;
	}
	else
		return TranslateMessage (pmsg);
}

static int
RbrtGetMessage (MSG * pmsg)
{
	if (gMessStored)
	{
		*pmsg = gStoredMess;
		gMessStored = FALSE;
		return TRUE;
	}

	if (!gIdleTimerOn)
		return GetMessage (pmsg, NULL, 0, 0);
	else
	{
		if (PeekMessage (pmsg, NULL, 0, 0, PM_REMOVE))
			return (pmsg->message != WM_QUIT);
		else
		{
			POINT p;

			GetCursorPos (&p);

			pmsg->hwnd = ghMainWindow;
			pmsg->message = WM_ENTERIDLE;
			pmsg->wParam = MSGF_USER;
			pmsg->lParam = (LPARAM) ghMainWindow;
			pmsg->time = GetTickCount ();
			pmsg->pt = p;
			return TRUE;
		}
	}
}

static UINT APIENTRY FileSelectorHook (HWND hdlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	if (uiMsg == WM_INITDIALOG)
	{
		HWND	window_handle;
		RECT	rect;
		int		x, y;

		window_handle	= GetParent (hdlg);
		
		GetWindowRect (window_handle, &rect);
		
		x	= (GetSystemMetrics (SM_CXSCREEN)>>1) - ((rect.right-rect.left)>>1);
		y	= (GetSystemMetrics (SM_CYSCREEN)>>1) - ((rect.bottom-rect.top)>>1);

		SetWindowPos (window_handle, NULL, x, y, 0, 0, SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOZORDER);
	}

	return 0;
}

void
HandleCleanRequest (CrossCallInfo * pcci)
{
	switch (pcci->mess)
	{
			case CcRqIDLETIMER:
			{
				gIdleTimerOn = pcci->p1;
				MakeReturn0Cci (pcci);
			} break;
		case CcRqBEEP:
			{
				MessageBeep (MB_ICONASTERISK);		/* PA: changed from 0xFFFFFFFF to MB_ICONASTERISK. */
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqBEGINPAINT:	/* hwnd; HDC result. */
			{
				HDC hdc;
				hdc = BeginPaint ((HWND) pcci->p1, &gPaintStruct);
				MakeReturn1Cci (pcci, (int) hdc);
			}
			break;

		case CcRqENDPAINT:		/* hwnd; no result.  */
			{
				EndPaint ((HWND) pcci->p1, &gPaintStruct);
				MakeReturn0Cci (pcci);
			}
			break;

		case CcRqGETDC: /* hwnd;
								   HDC result. */
			{
				HDC hdc;
				hdc = GetDC ((HWND) pcci->p1);
				MakeReturn1Cci (pcci, (int) hdc);
			}
			break;

		case CcRqRELEASEDC: 	/* hwnd, hdc;
								   no result. */
			{
				ReleaseDC ((HWND) pcci->p1, (HDC) pcci->p2);
				MakeReturn0Cci (pcci);
			}
			break;

		case CcRqINVALIDATEWINDOW:		/* hwnd;
										   no result. */
			{
				InvalidateRect ((HWND) pcci->p1, NULL, FALSE);
				MakeReturn0Cci (pcci);
			}
			break;

		/* PA: new alternative to invalidate part of window/control. */
		case CcRqINVALIDATERECT:		/* hwnd, left,top,right,bottom; no result. */
			{
				RECT rect;

				rect.left   = pcci->p2;
				rect.top    = pcci->p3;
				rect.right  = pcci->p4;
				rect.bottom = pcci->p5;

				InvalidateRect ((HWND) pcci->p1, &rect, FALSE);
				MakeReturn0Cci (pcci);
			}
			break;
		/* PA: previous version of CcRqDOMESSAGE.
		case CcRqDOMESSAGE: 	// no params; no result
			{
				MSG ms;
				BOOL msgdone;
				if (RbrtGetMessage (&ms))
				{
					LONG msgtime;

					msgtime = GetMessageTime ();

					gPrevMsgTime = msgtime;
					msgdone = FALSE;

					if (!gAcceleratorTableIsUpToDate)
						UpdateAcceleratorTable ();

					if (gAcceleratorTable)
						msgdone = TranslateAccelerator (ghMenuBarWindow, gAcceleratorTable, &ms);

					if (msgdone == FALSE && gActiveDialog)
						msgdone = IsDialogMessage (gActiveDialog, &ms);

					if (!msgdone)
					{
						RbrtTranslateMessage (&ms);
						DispatchMessage (&ms);
					}
					MakeReturn0Cci (pcci);
				}
				else
				{
					ErrorExit ("While Handling a CcRqDoMessage, a WM_QUIT was encountered");
				};
			}
			break;
		PA: end of previous implementation. */
		/* PA: as an experiment, CcRqDOMESSAGE also gets a bool argument that starts/end the idle timer. */
		case CcRqDOMESSAGE: 	/* set idle timer; no result. */
			{
				MSG ms;
				int msgresult;

				gIdleTimerOn = (BOOL) pcci->p1;
				msgresult = RbrtGetMessage (&ms);

				if (msgresult == -1)
					ErrorExit ("Fatal error: CcRqDoMessage, GetMessage result is -1");
				else if (msgresult == FALSE)
					ErrorExit ("Fatal error: CcRqDoMessage, GetMessage result is FALSE (WM_QUIT)");
				else
				{
					LONG msgtime = GetMessageTime ();

					gPrevMsgTime = msgtime;

					if (!gActiveDialog || !IsDialogMessage (gActiveDialog, &ms))
					{
						if (!gAcceleratorTableIsUpToDate)
							UpdateAcceleratorTable ();
						if (!gAcceleratorTable || !TranslateAccelerator (ghMenuBarWindow, gAcceleratorTable, &ms))
						{
							RbrtTranslateMessage (&ms);
							DispatchMessage (&ms);
						}
					}
					MakeReturn0Cci (pcci);
				}
			}
			break;

		/* PA: new implementation of CcRqMODIFYMENUITEM, using SetMenuItemInfo. */
		case CcRqMODIFYMENUITEM:	/* hitem, hmenu, textptr; no result.	*/
			{
				char *correcttext;
				MENUITEMINFO info;

				correcttext = CorrectMenuItemText ((char *) pcci->p3);

				info.cbSize        = (UINT) sizeof (MENUITEMINFO);
				info.fMask         = MIIM_TYPE;
				info.fType         = MFT_STRING;
				info.fState        = (UINT) 0;
				info.wID           = (UINT) pcci->p1;
				info.hSubMenu      = (HMENU) NULL;
				info.hbmpChecked   = NULL;
				info.hbmpUnchecked = NULL;
				info.dwItemData    = (DWORD) 0;
				info.dwTypeData    = (LPTSTR) correcttext;
				info.cch           = rstrlen (correcttext);

				SetMenuItemInfo ((HMENU) pcci->p2, (UINT) pcci->p1, FALSE, &info);

				rfree (correcttext);
				MakeReturn0Cci (pcci);
			} break;
		/* PA: previous implementation of CcRqMODIFYMENUITEM. 
		case CcRqMODIFYMENUITEM:		// HITEM, hmenu, textptr;		no result.
			{
				char *correcttext;
				correcttext = CorrectMenuItemText ((char *) pcci->p3);

				ModifyMenu ((HMENU) pcci->p2,			// hMenu	  
							(UINT) pcci->p1,			// hItem	  
							MF_BYCOMMAND | MF_STRING,	// Flags	  
							(UINT) pcci->p1,			// hItem	  
							(LPCTSTR) correcttext		// item text  
					);
				rfree (correcttext);
				MakeReturn0Cci (pcci);
			}
			break;
		PA: end of previous implemenation of CcRqMODIFYMENUITEM. */

		case CcRqAPPENDMENUITEM:		/* on/off, hmenu, textptr, marked;
										   HITEM result.	  */
			{
				UINT graystate, checkstate;
				HITEM hitem;
				char *correcttext;

				if (pcci->p1)
				{
					graystate = MF_ENABLED;
				}
				else
				{
					graystate = MF_GRAYED;
				}

				if (pcci->p4)
				{
					checkstate = MF_CHECKED;
				}
				else
				{
					checkstate = MF_UNCHECKED;
				}

				correcttext = CorrectMenuItemText ((char *) pcci->p3);

				hitem = NextItemHandle ();

				AppendMenu ((HMENU) pcci->p2,	/* hMenu	  */
							MF_STRING | graystate | checkstate, /* Flags	  */
							(UINT) hitem,		/* id		  */
							(LPCTSTR) correcttext		/* item text  */
					);

				rfree (correcttext);
				MakeReturn1Cci (pcci, hitem);

			} break;
		case CcRqINSERTMENUITEM:		/* on/off, hmenu, textptr, marked,
										   pos;    HITEM result. */
			{
				UINT graystate, checkstate;
				HITEM hitem;
				char *correcttext;

				if (pcci->p1)
				{
					graystate = MF_ENABLED;
				}
				else
				{
					graystate = MF_GRAYED;
				}

				if (pcci->p4)
				{
					checkstate = MF_CHECKED;
				}
				else
				{
					checkstate = MF_UNCHECKED;
				}

				correcttext = CorrectMenuItemText ((char *) pcci->p3);
				hitem = NextItemHandle ();

				InsertMenu ((HMENU) pcci->p2,			/* hMenu	  */
							(UINT) pcci->p5,			/* position   */
							MF_BYPOSITION | MF_STRING | graystate | checkstate,
														/* Flags	  */
							(UINT) hitem,				/* id		  */
							(LPCTSTR) correcttext		/* item text  */
					);

				rfree (correcttext);
				MakeReturn1Cci (pcci, hitem);
			}
			break;

		case CcRqITEMENABLE:	/* parent, HITEM, onoff; no result.  */
			{
				UINT greystate;

				if (pcci->p3)
				{
					greystate = MF_ENABLED;
				}
				else
				{
					greystate = MF_GRAYED;
				}
				EnableMenuItem ((HMENU) pcci->p1,			/* parent menu	*/
								(UINT) pcci->p2,			/* menu item id */
								MF_BYCOMMAND | greystate);	/* flags		*/
				MakeReturn0Cci (pcci);
			}
			break;
		/* PA: new alternative to destroy a menu 'physically' */
		case CcRqDESTROYMENU:			/* HMENU; no result. */
			{
				DestroyMenu ((HMENU) pcci->p1);
				MakeReturn0Cci (pcci);
			}
			break;
		/* PA: new alternative to remove a menu logically */
		case CcRqDELETEMENU:			/* HMENU, HITEM; no result. */
			{
				DeleteMenu ((HMENU) pcci->p1,		/* parent menu  */
							(UINT) pcci->p2,		/* menu item id */
							MF_BYCOMMAND);
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqREMOVEMENUITEM:		/* menu, HITEM;
										   no result. */
			{
				if (gShortcutTable != NULL)
					RemoveShortcutFromTable (pcci->p2, gShortcutTable);

				RemoveMenu ((HMENU) pcci->p1,
							(UINT) pcci->p2,
							MF_BYCOMMAND);
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqAPPENDSEPARATOR:		/* hmenu; no result. */
			{
				AppendMenu ((HMENU) pcci->p1,	/* hMenu				 */
							MF_SEPARATOR,		/* Flags				 */
							0,	/* no id for separator	 */
							NULL);		/* no text for separator */
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqINSERTSEPARATOR:		/* hmenu, pos
										   no result. */
			{
				InsertMenu ((HMENU) pcci->p1,	/* hMenu				 */
							(UINT) pcci->p2,	/* position 			 */
							MF_BYPOSITION | MF_SEPARATOR,		/* Flags				 */
							0,	/* no id for separator	 */
							NULL);		/* no text for separator */
				MakeReturn0Cci (pcci);
			}
			break;
		/* PA: new implementation of CcRqMODIFYMENU, using SetMenuItemInfo. */
		case CcRqMODIFYMENU:	/* hitem, hmenu, textptr; no result.	*/
			{
				char *correcttext;
				MENUITEMINFO info;

				correcttext = CorrectMenuItemText ((char *) pcci->p3);

				info.cbSize        = (UINT) sizeof (MENUITEMINFO);
				info.fMask         = MIIM_TYPE;
				info.fType         = MFT_STRING;
				info.fState        = (UINT) 0;
				info.wID           = (UINT) pcci->p1;
				info.hSubMenu      = (HMENU) pcci->p2;
				info.hbmpChecked   = NULL;
				info.hbmpUnchecked = NULL;
				info.dwItemData    = (DWORD) 0;
				info.dwTypeData    = (LPTSTR) correcttext;
				info.cch           = rstrlen (correcttext);

				SetMenuItemInfo ((HMENU) pcci->p2, (UINT) pcci->p1, FALSE, &info);

				rfree (correcttext);
				MakeReturn0Cci (pcci);
			} break;
		/* PA: previous implementation of CcRqMODIFYMENU. 
		case CcRqMODIFYMENU:	// hsubmenu, hmenu, textptr; no result.		
			{
				char *correcttext;

				correcttext = CorrectMenuItemText ((char *) pcci->p3);

				ModifyMenu ((HMENU) pcci->p2,			// hMenu		
							(UINT) pcci->p1,			// hSubMenu		
							MF_BYCOMMAND | MF_STRING | MF_POPUP,
														// Flags		
							(UINT) pcci->p1,			// hSubMenu 	
							(LPCTSTR) correcttext		// item text	
					);
				rfree (correcttext);
				MakeReturn0Cci (pcci);
			} break;
		PA: end of previous implementation of CcRqMODIFYMENU.	*/
		/* PA: new alternative to insert a menu into the menu bar. */
		case CcRqINSERTMENU:	/* on/off, hmenu, textptr, hsubmenu, pos; no result */
			{
				UINT graystate;
				char *correcttext;

				graystate = 0;
				if (pcci->p1)
				{
					graystate = MF_ENABLED;
				}
				else
				{
					graystate = MF_GRAYED;
				}
				correcttext = CorrectMenuItemText ((char *) pcci->p3);

				InsertMenu ((HMENU) pcci->p2,						/* hMenu		*/
							(UINT) pcci->p5,						/* position		*/
							MF_BYPOSITION | MF_POPUP | graystate,	/* flags		*/
							(UINT) pcci->p4,						/* hSubMenu		*/
							(LPCTSTR) correcttext					/* item text	*/
					);
				rfree (correcttext);
				MakeReturn0Cci (pcci);
			} break;
		case CcRqAPPENDMENU:	/* on/off, hmenu, textptr, hsubmenu; no
								   result.		*/
			{
				UINT graystate;
				char *correcttext;

				graystate = 0;
				if (pcci->p1)
				{
					graystate = MF_ENABLED;
				}
				else
				{
					graystate = MF_GRAYED;
				}
				correcttext = CorrectMenuItemText ((char *) pcci->p3);

				AppendMenu ((HMENU) pcci->p2,					/* hMenu	  */
							MF_STRING | MF_POPUP | graystate,	/* Flags	  */
							(UINT) pcci->p4,					/* hSubMenu   */
							(LPCTSTR) correcttext				/* item text  */
					);

				rfree (correcttext);
				MakeReturn0Cci (pcci);
			} break;
		case CcRqMENUENABLE:	/* parent, zero based position of menu, onoff; no result. */
			{
				UINT greystate;

				if (pcci->p3)
				{
					greystate = MF_ENABLED;
				}
				else
				{
					greystate = MF_GRAYED;
				}
				EnableMenuItem ((HMENU) pcci->p1,			/* parent menu	*/
								(UINT) pcci->p2,			/* submenu	 	*/
								MF_BYPOSITION | greystate);	/* flags		*/
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqDRAWMBAR:		/* no params;
								   no result. */
			{
				DrawMenuBar (ghMenuBarWindow);
				MakeReturn0Cci (pcci);
			}
			break;

		case CcRqCREATEMBAR:	/* no params;
								   MENU result.   */
			MakeReturn1Cci (pcci, (int) CreateMenu ());
			break;

		case CcRqCREATEPOPMENU: /* no params;
										   MENU result.   */
			MakeReturn1Cci (pcci, (int) CreatePopupMenu ());
			break;

		case CcRqCHECKMENUITEM: /* menu, HITEM, on/off; no result.	*/
			{
				UINT check;
				if (pcci->p3)
				{
					check = MF_CHECKED;
				}
				else
				{
					check = MF_UNCHECKED;
				}
				CheckMenuItem ((HMENU) pcci->p1, (UINT) pcci->p2, MF_BYCOMMAND | check);
				MakeReturn0Cci (pcci);
			}
			break;

		case CcRqCREATEMENUWINDOW:		/* hmenu, titleptr;
										   WND result.	  */
			{
				POINT dim;

				/* create the window */

				W95GetMenuBarWindowDimensions (&dim);

				gMenuBarWindowHeight = dim.y;
				ghMenuBarWindow
					= CreateWindowEx (0,
									  MenuBarClassName,					/* Class name					 */
									  gAppName,							/* Window title 				 */
									  WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_THICKFRAME | WS_SYSMENU,
																		/* style flags					 */
									  0, 0,								/* x, y 						 */
									  dim.x, dim.y,						/* width, height				 */
									  ghMainWindow,						/* Parent window				 */
									  (HMENU) pcci->p1,					/* menu handle					 */
									  (HANDLE) ghInst,					/* Instance that owns the window */
									  0);

				ShowWindow (ghMenuBarWindow, SW_SHOWMAXIMIZED);
				/* UpdateWindow?? */
				MakeReturn1Cci (pcci, (int) ghMenuBarWindow);
			}
			break;

		case CcRqCREATEFIXEDWINDOW: 	/* textptr, l,t,w,h;
										   HWND result. */
			{
				HWND whandle;
				POINT dimensions;
				char *title;
				int x, y;

				title = (char *) pcci->p1;
				x = pcci->p2;
				y = pcci->p3 + GetMenuBarOffSet ();

				dimensions.x = pcci->p4;
				dimensions.y = pcci->p5;

				W95AdjustFixedWindowDimensions (&dimensions);

				/* create the window */
				whandle
					= CreateWindow (DocWindowClassName, /* Class name					 */
									title,		/* Window title 				 */
									CleanFixedWindowStyle,		/* style flags					 */
									x, y,		/* x, y 						 */
									dimensions.x, dimensions.y, /* width, height				 */
									ghMainWindow,		/* Parent window				 */
									NULL,		/* menu handle					 */
									(HANDLE) ghInst,	/* Instance that owns
														   the window */
									0);
				ShowWindow (whandle, SW_SHOWNORMAL);
				UpdateWindow (whandle);
				rprintf ("Created Window with handle %d, title = \"%s\"\n", whandle);
				MakeReturn1Cci (pcci, (int) whandle);
			}
			break;
		case CcRqCREATESCROLLWINDOW:	/* textptr, l,t,w,h;
										   HWND result. */
			{
				HWND whandle;
				POINT dims, adjdims, winpos, maxsize;
				LPCTSTR pwintitle;

				pwintitle = (LPCTSTR) pcci->p1;
				winpos.x = pcci->p2;
				winpos.y = pcci->p3 + GetMenuBarOffSet ();
				dims.x = pcci->p4;
				dims.y = pcci->p5;

				GetMinMaxInfoFromClean ((HWND) - 1, &maxsize, NULL);

				if (dims.x < maxsize.x)
					adjdims.y = dims.y + GetSystemMetrics (SM_CYHSCROLL);
				else
					adjdims.y = dims.y;
				if (dims.y < maxsize.y)
					adjdims.x = dims.x + GetSystemMetrics (SM_CXVSCROLL);
				else
					adjdims.x = dims.x;

				W95AdjustScrollWindowDimensions (&adjdims);

				/* create the window */
				whandle
					= CreateWindowEx (WS_EX_CLIENTEDGE, /* Extended style				 */
									  DocWindowClassName,		/* Class name					 */
									  pwintitle,		/* Window title 				 */
									  CleanScrollWindowStyle,	/* style flags					 */
									  winpos.x, winpos.y,		/* x, y 						 */
									  adjdims.x, adjdims.y, 	/* width, height				 */
									  ghMainWindow, 	/* Parent window				 */
									  NULL, 	/* menu handle					 */
									  (HANDLE) ghInst,	/* Instance that owns
														   the window */
									  0);
				ShowWindow (whandle, SW_SHOWNORMAL);
/*		   UpdateWindow(whandle); */
				MakeReturn1Cci (pcci, (int) whandle);
			}
			break;
		/* PA: Old CrossCall constant reused for creating windows. */
		case CcRqCREATEWINDOW:	/* textptr, l,t,w,h, flags;
										   HWND result. */
			{
				HWND    whandle;
				POINT   dims, winpos;
				LPCTSTR pwintitle;
				DWORD   styleFlags, exStyleFlags;

				pwintitle    = (LPCTSTR) pcci->p1;
				winpos.x     = pcci->p2;
				winpos.y     = pcci->p3 + GetMenuBarOffSet ();
				dims.x       = pcci->p4;
				dims.y       = pcci->p5;
				styleFlags   = (DWORD) pcci->p6;
				exStyleFlags = (DWORD) 0;

				W95AdjustCleanWindowDimensions (styleFlags, &dims);

				if (styleFlags&WS_THICKFRAME != 0)				/* If resizable*/
				{
					exStyleFlags |= WS_EX_CLIENTEDGE;			/* then provide a 3D look to the window. */
				}

				/* create the window */
				whandle
					= CreateWindowEx (exStyleFlags,				/* Extended style					*/
									  DocWindowClassName,		/* Class name						*/
									  pwintitle,				/* Window title						*/
									  styleFlags,				/* style flags						*/
									  winpos.x, winpos.y,		/* x, y								*/
									  dims.x,dims.y,		 	/* width, height					*/
									  ghMainWindow,				/* Parent window					*/
									  NULL,						/* menu handle						*/
									  (HANDLE) ghInst,			/* Instance that owns the window	*/
									  0);
				ShowWindow (whandle, SW_SHOWNORMAL);
				MakeReturn1Cci (pcci, (int) whandle);
			}
			break;
		case CcRqDESTROYWINDOW: /* hwnd; no result. */
			{
				DestroyWindow ((HWND) pcci->p1);
				ActivateTopWindow ();
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqGETFOREGROUNDWINDOW:	/* no params;	 HWND result. */
			{
				HWND hwin;
				HWND found;

				if (gAppRunning && gModalDialogCount == 0)
				{
					ActivateTopWindow ();
				}

				found = NULL;

				hwin = GetWindow (ghMainWindow, GW_HWNDFIRST);
				while (hwin != NULL && found == NULL)
				{
					if (GetWindow (hwin, GW_OWNER) == ghMainWindow)
					{
						char text[64];

						GetClassName (hwin, text, 63);

						if (strequal (text, DocWindowClassName))
							found = hwin;
					}
					hwin = GetWindow (hwin, GW_HWNDNEXT);
				}
				MakeReturn1Cci (pcci, (int) found);
			}
			break;
		case CcRqSETFOREGROUNDWINDOW:	/* hwnd;		   no result.	*/
			{
				if (gAppRunning && gModalDialogCount == 0)
					SetActiveWindow ((HWND) pcci->p1);
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqSETWINDOWTITLE:		/* hwnd, textptr		no result. */
			{
				rprintf ("SWT: handle = %d, text = \"%s\"\n", (HWND) pcci->p1, (char *) pcci->p2);
				SetWindowText ((HWND) pcci->p1, (char *) pcci->p2);
				AdjustMenuBarName ();
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqGETWINDOWTEXT: /* hwnd;  textptr result. */
			{
				char *textptr;
				HWND hwnd;
				int length;

				hwnd = (HWND) pcci->p1;
				length = GetWindowTextLength (hwnd);

				textptr = (char *) rmalloc (length + 1);
				GetWindowText (hwnd, textptr, length + 1);
				textptr[length] = 0;
				MakeReturn1Cci (pcci, (int) textptr);
			}
			break;
		case CcRqMSGBOX:		/* textptr; no result. */
			{
				MessageBox (ghMainWindow, (LPCTSTR) pcci->p1, "Clean Application Message", MB_TASKMODAL | MB_OK | MB_ICONINFORMATION);
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqGETFONTNAMES:	/* no params;
								   no result. */
			{
				HDC hdc;

				hdc = GetDC (ghMainWindow);
				EnumFontFamilies (hdc, NULL, (FONTENUMPROC) EnumFontNameProc, 0);
				ReleaseDC (ghMainWindow, hdc);
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqGETFONTSIZES:	/* textptr;
								   no result. */
			{
				HDC hdc;

				hdc = GetDC (ghMainWindow);
				EnumFontFamilies (hdc, (char *) pcci->p1, (FONTENUMPROC) EnumFontSizeProc, 0);
				ReleaseDC (ghMainWindow, hdc);
				rfree ((char *) pcci->p1);
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqSETHSCROLLINFO:		/* hwnd, min, max, thumb, winsize;
										   no result. */
		case CcRqSETVSCROLLINFO:		/* hwnd, min, max, thumb, winsize;
										   no result. */
			{
				SCROLLINFO sif, sif2;
				int which;

				sif.cbSize = sizeof (SCROLLINFO);
				sif.fMask = SIF_ALL;
				sif.nMin = pcci->p2;
				sif.nMax = pcci->p3 - 1;
				sif.nPage = pcci->p5;
				sif.nPos = pcci->p4;

				which = (pcci->mess == CcRqSETHSCROLLINFO) ? SB_HORZ : SB_VERT;

				gInWMSIZE = TRUE;
				SetScrollInfo ((HWND) pcci->p1, which, &sif, TRUE);
				gInWMSIZE = FALSE;

				sif2.cbSize = sizeof (SCROLLINFO);
				sif2.fMask = SIF_ALL;

				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqGETCLIENTSIZE: /* hwnd;		width, height result.  */
			{
				RECT rect;

				GetClientRect ((HWND) pcci->p1, &rect);

				MakeReturn2Cci (pcci, rect.right - rect.left, rect.bottom - rect.top);
			}
			break;
		case CcRqGETSCROLLFRAME:		/* hwnd;   width, heigth result */
			{
				RECT rect;
				POINT size;

				GetWindowRect ((HWND) pcci->p1, &rect);

				size.x = rect.right - rect.left;
				size.y = rect.bottom - rect.top;

				size.x -= 2 * GetSystemMetrics (SM_CXSIZEFRAME) + 4;
				size.y -= 2 * GetSystemMetrics (SM_CYSIZEFRAME) + 4 +
					GetSystemMetrics (SM_CYCAPTION);

				MakeReturn2Cci (pcci, size.x, size.y);
			}
			break;
		/* PA: new alternative to (en/dis)able windows/dialogues. */
		case CcRqSETSELECTWINDOW:	/* hwnd, hasHScroll, hasVScroll, toAble, modalContext; no result. */
			{
				HWND window;
				BOOL hasHScroll, hasVScroll, toAble, modalContext;

				window       = (HWND) pcci->p1;
				hasHScroll   = (BOOL) pcci->p2;
				hasVScroll   = (BOOL) pcci->p3;
				toAble       = (BOOL) pcci->p4;
				modalContext = (BOOL) pcci->p5;

				if (modalContext)					/* PA: if not a modal context, then do not disable window	*/
					EnableWindow (window,toAble);	/*     because it can't be moved, or closed. */
				if (hasHScroll)
					EnableScrollBar (window,SB_HORZ,toAble ? ESB_ENABLE_BOTH : ESB_DISABLE_BOTH);
				if (hasVScroll)
					EnableScrollBar (window,SB_VERT,toAble ? ESB_ENABLE_BOTH : ESB_DISABLE_BOTH);

				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqGETWINDOWPOS:	/* hwnd;   width, heigth result */
			{
				RECT rect;

				GetWindowRect ((HWND) pcci->p1, &rect);

				rect.top -= GetMenuBarOffSet ();
				MakeReturn2Cci (pcci, rect.left, rect.top);
			}
			break;
		/* PA: new alternative to set the position of windows/controls. */
		case CcRqSETWINDOWPOS:	/* hwnd, x,y; no result. */
			{
				int x,y;
				UINT flags;

				x = pcci->p2;
				y = pcci->p3;
				flags = SWP_NOSIZE			/* retain size */
					  | SWP_NOZORDER;		/* retain Z order */

				SetWindowPos ((HWND) pcci->p1, HWND_TOP, x,y, 0,0, flags);
				MakeReturn0Cci (pcci);
			}
			break;
		/* PA: new alternative to set the size of windows/controls. */
		case CcRqSETWINDOWSIZE: /* hwnd, w,h; no result. */
			{
				int w,h;
				UINT flags;

				w = pcci->p2;
				h = pcci->p3;
				flags = SWP_NOMOVE			/* retain position */
					  | SWP_NOZORDER;		/* retain Z order */

				SetWindowPos ((HWND) pcci->p1, HWND_TOP, 0,0, w,h, flags);
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqSCROLLWINDOW:	/* hwnd, dx, dy, hthumb, vthumb; no result. */
			{
				SCROLLINFO sif;
				sif.fMask = SIF_ALL;
				sif.cbSize = sizeof (SCROLLINFO);

				ScrollWindowEx ((HWND) pcci->p1, pcci->p2, pcci->p3, NULL, NULL, NULL, NULL, SW_INVALIDATE);
				if (GetScrollInfo ((HWND) pcci->p1, SB_HORZ, &sif))
				{
					sif.nPos = pcci->p4;
					SetScrollInfo ((HWND) pcci->p1, SB_HORZ, &sif, TRUE);
				}
				if (GetScrollInfo ((HWND) pcci->p1, SB_VERT, &sif))
				{
					sif.nPos = pcci->p5;
					SetScrollInfo ((HWND) pcci->p1, SB_VERT, &sif, TRUE);
				}
				UpdateWindow ((HWND) pcci->p1);
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqRESIZESCROLL:	/* hwnd, width, height, maxwidth, maxheight;
								   adjusted width,height result; */
			{
				POINT oldframesize, barsize, newclientsize, newmaxsize, finalframesize,
					finalclientsize;
				RECT oldframe;
				HWND hWin;
				BOOL needResize;

				hWin = (HWND) pcci->p1;
				newclientsize.x = pcci->p2;
				newclientsize.y = pcci->p3;
				newmaxsize.x = pcci->p4;
				newmaxsize.y = pcci->p5;

				GetWindowRect (hWin, &oldframe);
				oldframesize.x = oldframe.right - oldframe.left;
				oldframesize.y = oldframe.bottom - oldframe.top;
				oldframesize.x -= 2 * GetSystemMetrics (SM_CXSIZEFRAME) + 4;
				oldframesize.y -= 2 * GetSystemMetrics (SM_CYSIZEFRAME) + 4 +
					GetSystemMetrics (SM_CYCAPTION);

				barsize.x = GetSystemMetrics (SM_CXVSCROLL);
				barsize.y = GetSystemMetrics (SM_CYHSCROLL);

				/* we may have to adjust the new size for scrollbars */

				if (newclientsize.x < newmaxsize.x)
				{		/* we need a horizontal scrollbar */
					if (newclientsize.y + barsize.y <= oldframesize.y)
					{	/* expand frame for scrollbar */
						finalframesize.y = newclientsize.y + barsize.y;
						finalclientsize.y = newclientsize.y;
					}
					else
					{	/* shrink clientsize for scrollbar */
						finalframesize.y = newclientsize.y;
						finalclientsize.y = newclientsize.y - barsize.y;
					}
				}
				else
				{		/* no scrollbar needed */
					finalframesize.y = newclientsize.y;
					finalclientsize.y = newclientsize.y;
				}

				if (newclientsize.y < newmaxsize.y)
				{		/* we need a vertical scrollbar */
					if (newclientsize.x + barsize.x <= oldframesize.x)
					{	/* expand frame for scrollbar */
						finalframesize.x = newclientsize.x + barsize.x;
						finalclientsize.x = newclientsize.x;
					}
					else
					{	/* shrink clientsize for scrollbar */
						finalframesize.x = newclientsize.x;
						finalclientsize.x = newclientsize.x - barsize.x;
					}
				}
				else
				{		/* no scrollbar needed */
					finalframesize.x = newclientsize.x;
					finalclientsize.x = newclientsize.x;
				}

				needResize = finalframesize.x != oldframesize.x || finalframesize.y != oldframesize.y;

				W95AdjustScrollWindowDimensions (&finalframesize);

				if (needResize)
				{
					gInWMSIZE = TRUE;
					SetWindowPos (hWin,
								  0, 0, 0,
								  finalframesize.x, finalframesize.y,
								  SWP_NOZORDER |
								  SWP_NOMOVE |
								  SWP_NOACTIVATE
						);
					gInWMSIZE = FALSE;
				}

				MakeReturn2Cci (pcci, finalclientsize.x, finalclientsize.y);
			}
			break;
		case CcRqRESIZEFIXED:	/* hwnd, width, heigth;  no result */
			{
				HWND hWin;
				POINT size;

				hWin = (HWND) pcci->p1;
				size.x = pcci->p2;
				size.y = pcci->p3;

				W95AdjustFixedWindowDimensions (&size);

				gInWMSIZE = TRUE;
				SetWindowPos (hWin,
							  0, 0, 0,
							  size.x, size.y,
							  SWP_NOZORDER |
							  SWP_NOMOVE |
							  SWP_NOACTIVATE
					);
				gInWMSIZE = FALSE;

				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqFIXEDTOSCROLL: /* hwnd, width, height;   new hwnd,
										   width, height result */
			{
				HWND hWin, newhandle;
				POINT finalframesize, finalclientsize, reqsize, maxscrollsize,
					barsize;
				BOOL needhbar, needvbar;

				hWin = (HWND) pcci->p1;
				reqsize.x = pcci->p2;
				reqsize.y = pcci->p3;

				WinMaxScrollWindowSize ((int *) &(maxscrollsize.x), (int *) &(maxscrollsize.y));

				barsize.x = GetSystemMetrics (SM_CXVSCROLL);
				barsize.y = GetSystemMetrics (SM_CYHSCROLL);

				needhbar = reqsize.x > maxscrollsize.x;
				needvbar = reqsize.y > maxscrollsize.y;

				if (needhbar && needvbar)
				{
					finalframesize = maxscrollsize;
					finalclientsize.x = finalframesize.x - barsize.x;
					finalclientsize.y = finalframesize.y - barsize.y;
				}
				else if (needhbar && !needvbar)
				{
					if (reqsize.y + barsize.y > maxscrollsize.y)
					{
						finalframesize.x = maxscrollsize.x;
						finalframesize.y = maxscrollsize.y;
						finalclientsize.x = finalframesize.x;
						finalclientsize.y = finalframesize.y - barsize.y;
					}
					else
					{
						finalframesize.x = maxscrollsize.x;
						finalframesize.y = reqsize.y + barsize.y;
						finalclientsize.x = finalframesize.x;
						finalclientsize.y = reqsize.y;
					}
				}
				else if (!needhbar && needvbar)
				{
					if (reqsize.x + barsize.x > maxscrollsize.x)
					{
						finalframesize.x = maxscrollsize.x;
						finalframesize.y = maxscrollsize.y;
						finalclientsize.x = finalframesize.x - barsize.x;
						finalclientsize.y = finalframesize.y;
					}
					else
					{
						finalframesize.x = reqsize.x + barsize.x;
						finalframesize.y = maxscrollsize.y;
						finalclientsize.x = reqsize.x;
						finalclientsize.y = finalframesize.y;
					}
				}
				else
				{		/* huh? */
					rprintf ("fs: no scrollbars needed\n");
				}

				{
					char title[100];
					HWND prevwin;
					WINDOWPLACEMENT wPlacement;

					GetWindowText (hWin, title, 100);
					title[99] = 0;

					prevwin = GetWindow (hWin, GW_HWNDPREV);

					wPlacement.length = sizeof (WINDOWPLACEMENT);
					GetWindowPlacement (hWin, &wPlacement);
					W95AdjustScrollWindowDimensions (&finalframesize);

					DestroyWindow (hWin);
					newhandle
						= CreateWindowEx (WS_EX_CLIENTEDGE, 	/* Extended style				 */
										  DocWindowClassName,	/* Class name					 */
										  title,		/* Window title 				 */
										  CleanScrollWindowStyle,		/* style flags					 */
										  wPlacement.rcNormalPosition.left, 	/* x						 */
										  wPlacement.rcNormalPosition.top,		/* y						 */
										  finalframesize.x, 	/* width						 */
										  finalframesize.y, 	/* height												 */
										  ghMainWindow, /* Parent window				 */
										  NULL, /* menu handle					 */
										  (HANDLE) ghInst,		/* Instance that owns
																   the window */
										  0);

					if (prevwin != NULL && prevwin != ghMenuBarWindow)
					{
						SetWindowPos (newhandle, prevwin, 0, 0, 0, 0, SWP_NOACTIVATE |
									  SWP_NOMOVE |
									  SWP_NOSIZE
							);
					}
					ShowWindow (newhandle, SW_SHOWNORMAL);

				}
				MakeReturn3Cci (pcci, (int) newhandle, finalclientsize.x, finalclientsize.y);
			}
			break;
		case CcRqCHANGEWINDOWCURSOR:	/* hwnd, cursor code;		 no
										   result. */
			{
				HWND hwnd;
				POINT p;
				int cursorcode;

				hwnd = (HWND) pcci->p1;
				cursorcode = pcci->p2;

				GetCursorPos (&p);

				if (hwnd == WindowFromPoint (p) &&
					SendMessage (hwnd, WM_NCHITTEST, 0, MAKELPARAM (p.x, p.y)) == HTCLIENT)
				{
					SetCursorFromCode (cursorcode);
				}

				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqOBSCURECURSOR: /* no params; no result. */
			{
				SetCursor (GetHiddenCursor ());
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqSETGLOBALCURSOR:		/* cursorcode; no result. */
			{
				HWND hwnd;

				gGlobalCursorCode = pcci->p1;

				hwnd = ApplicationWindowUnderCursor ();

				if (hwnd != NULL)
					SetCursorFromCode (gGlobalCursorCode);

				MakeReturn0Cci (pcci);

			}
			break;
		case CcRqRESETCURSOR:	/* no params, no result. */
			{
				HWND hwnd;

				gGlobalCursorCode = -1;

				hwnd = ApplicationWindowUnderCursor ();

				if (hwnd != NULL)
				{
					int hittestvalue;
					POINT p;

					GetCursorPos (&p);
					hittestvalue = SendMessage (hwnd, WM_NCHITTEST, 0, MAKELPARAM (p.x, p.y));
					SendMessage (hwnd, WM_SETCURSOR, (WPARAM) hwnd, MAKELPARAM (hittestvalue, WM_MOUSEMOVE));
				}

				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqSETSCROLLRANGE:	/* PA: new alternative for setting range of scrollbars. */
									/* hwnd, iBar, min, max, redraw, no result */
			{
				HWND hwnd;
				int min, max, iBar;
				BOOL redraw;

				hwnd = (HWND) pcci->p1;
				iBar = pcci->p2;
				min  = pcci->p3;
				max  = pcci->p4;
				redraw = (BOOL) pcci->p5;

				SetScrollRange (hwnd, iBar, min, max, redraw);

				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqSETSCROLLPOS:	/* PA: new alternative for setting pos of scrollbars. */
								/* hwnd, iBar, thumb, redraw, no result */
			{
				HWND hwnd;
				int thumb, iBar;
				BOOL redraw;

				hwnd  = (HWND) pcci->p1;
				iBar  = pcci->p2;
				thumb = pcci->p3;
				redraw = (BOOL) pcci->p4;

				SetScrollPos (hwnd, iBar, thumb, redraw);

				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqSETSCROLLSIZE:	/* PA: new alternative for setting thumb size of scrollbars. */
								/* hwnd, iBar, size, redraw, no result */
			{
				HWND hwnd;
				int size, iBar;
				BOOL redraw;
				SCROLLINFO sif;

				hwnd  = (HWND) pcci->p1;
				iBar  = pcci->p2;
				size  = pcci->p3;
				redraw = (BOOL) pcci->p4;
				
				sif.cbSize = sizeof (SCROLLINFO);
				sif.fMask = SIF_PAGE;
				sif.nPage = size;

				SetScrollInfo (hwnd, iBar, &sif, redraw);

				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqSETEDITSELECTION:	/* PA: new alternative for setting selection of edit controls. */
									/* hwnd, first, last, no result. */
			{
				HWND hwnd;
				int first,last;

				hwnd  = (HWND) pcci->p1;
				first = pcci->p2;
				last  = pcci->p3;

				SendMessage (hwnd, EM_SETSEL, (WPARAM) first, (LPARAM) last);		/* Set the selection of the edit control. */
				SendMessage (hwnd, EM_SCROLLCARET, 0,0);		/* Let the caret be displayed - (w/l)Param MUST be 0. */

				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqCREATETIMER:	/* milliseconds;	  HITEM result. */
			{
				HITEM hitem;

				hitem = NextItemHandle ();
				SetTimer (ghMainWindow, (UINT) hitem, (UINT) pcci->p1, NULL);
				MakeReturn1Cci (pcci, hitem);
			}
			break;
		case CcRqKILLTIMER: 	/* HITEM;	 no result. */
			{
				KillTimer (ghMainWindow, (UINT) pcci->p1);
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqGETCURTIME:	/* no params;  hours, minutes, seconds. */
			{
				SYSTEMTIME time;

				GetLocalTime (&time);
				MakeReturn3Cci (pcci, time.wHour, time.wMinute, time.wSecond);
			}
			break;
		case CcRqGETCURDATE:	/* no params;  year, month, day, weekday. */
			{
				SYSTEMTIME time;

				GetLocalTime (&time);
				MakeReturn4Cci (pcci, time.wYear, time.wMonth, time.wDay, time.wDayOfWeek + 1);
			}
			break;
		case CcRqWAIT:	/* milliseconds;	no result  */
			{
				Sleep (pcci->p1);
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqGETBLINKTIME:	/* no params;	   millisec result. */
			{
				MakeReturn1Cci (pcci, (int) GetCaretBlinkTime ());
			}
			break;
		case CcRqFILEOPENDIALOG:		/* no params;  bool, textptr result; */
			{
				OPENFILENAME ofn;
				BOOL success;

				ofn.lStructSize = sizeof (OPENFILENAME);

				if (IsWindowEnabled (ghMainWindow))
				{
					ofn.hwndOwner = ghMainWindow;
				}
				else
				{
					ofn.hwndOwner = GetActiveWindow ();
				}
				ofn.hInstance = NULL;
				ofn.lpstrFilter = NULL;
				ofn.lpstrCustomFilter = NULL;
				ofn.nMaxCustFilter = 0;
				ofn.nFilterIndex = 0;
				ofn.lpstrFile = (LPSTR) rmalloc (MAX_PATH);
				ofn.lpstrFile[0] = '\0';
				ofn.nMaxFile = MAX_PATH;
				ofn.lpstrFileTitle = NULL;
				ofn.nMaxFileTitle = 0;
				ofn.lpstrInitialDir = NULL;
				ofn.lpstrTitle = NULL;
				ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST |
					OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_ENABLEHOOK;		// PA: OFN_ENABLEHOOK added from Ronny
				ofn.lpstrDefExt = NULL;
				ofn.lCustData = 0;
				ofn.lpfnHook = &FileSelectorHook;								// PA: &FileSelectorHook instead of NULL from Ronny
				ofn.lpTemplateName = NULL;

				gProhibitWindowActivation++;
				success = GetOpenFileName (&ofn);
				gProhibitWindowActivation--;

				if (success)
				{
					MakeReturn2Cci (pcci, success, (int) ofn.lpstrFile);
					/* and have the calling clean function deallocate the
					   filename buffer */
				}
				else
				{
					MakeReturn2Cci (pcci, success, (int) NULL);
					rfree (ofn.lpstrFile);
				}
			}
			break;
		case CcRqFILESAVEDIALOG:		/* promptptr, nameptr; bool, textptr
										   result; */
			{
				OPENFILENAME ofn;
				BOOL success;
				char *promptptr;
				char *nameptr;

				promptptr = (char *) pcci->p1;
				nameptr = (char *) pcci->p2;

				if (rstrlen (promptptr) == 0)
					promptptr = NULL;	/* the calling clean function will
										   deallocate the memory allocated
										   for this empty string */

				ofn.lStructSize = sizeof (OPENFILENAME);

				if (IsWindowEnabled (ghMainWindow))
				{
					ofn.hwndOwner = ghMainWindow;
				}
				else
				{
					ofn.hwndOwner = GetActiveWindow ();
				}

				ofn.lpstrFilter = NULL;
				ofn.lpstrCustomFilter = NULL;
				ofn.nMaxCustFilter = 0;
				ofn.nFilterIndex = 0;
				ofn.lpstrFile = (LPSTR) rmalloc (MAX_PATH);
				if (rstrlen (nameptr) < MAX_PATH)
				{
					rscopy (ofn.lpstrFile, nameptr);
				}
				else
				{
					rsncopy (ofn.lpstrFile, nameptr, MAX_PATH - 1);
					ofn.lpstrFile[MAX_PATH - 1] = '\0';
				}
				ofn.nMaxFile = MAX_PATH;
				ofn.lpstrFileTitle = NULL;
				ofn.nMaxFileTitle = 0;
				ofn.lpstrInitialDir = NULL;
				ofn.lpstrTitle = promptptr;
				ofn.Flags = OFN_EXPLORER | OFN_OVERWRITEPROMPT |
					OFN_HIDEREADONLY | OFN_ENABLEHOOK;			// PA: OFN_ENABLEHOOK added from Ronny
				ofn.lpstrDefExt = NULL;
				ofn.lCustData = 0;
				ofn.lpfnHook = &FileSelectorHook;				// PA: &FileSelectorHook instead of NULL from Ronny
				ofn.lpTemplateName = NULL;

				gProhibitWindowActivation++;
				success = GetSaveFileName (&ofn);
				gProhibitWindowActivation--;

				if (success)
				{
					MakeReturn2Cci (pcci, success, (int) ofn.lpstrFile);
					/* and have the calling clean function deallocate the
					   filename buffer */
				}
				else
				{
					MakeReturn2Cci (pcci, success, (int) NULL);
					rfree (ofn.lpstrFile);
				}
			}
			break;
		case CcRqCREATEDIALOG:	/* textptr, x,y,w,h, isModal;
								   HWND result. */
			{
				WORD *p, *pdlgtemplate;
				int nchar;
				DWORD lStyle;
				HWND hwnd;
				BOOL isModal;

				isModal = pcci->p6;	/* PA: isModal states whether the dialogue is modal. */

				/* allocate some memory to play with  */
				pdlgtemplate = p = (PWORD) rmalloc (1000);

				/* start to fill in the dlgtemplate information.  addressing
				   by WORDs */
				lStyle = WS_CAPTION | DS_SETFONT | DS_MODALFRAME | WS_SYSMENU;
				if (isModal)				/* PA: if it is a modal dialogue, then add the DS_SYSMODAL style. */
				{
					lStyle |= DS_SYSMODAL;
				}

				*p++ = LOWORD (lStyle);
				*p++ = HIWORD (lStyle);
				*p++ = 0;		/* LOWORD (lExtendedStyle) */
				*p++ = 0;		/* HIWORD (lExtendedStyle) */
				*p++ = 0;		/* NumberOfItems */
				*p++ = 0;		/* x  (dummy value) */
				*p++ = 0;		/* y  (dummy value) */
				*p++ = 1000;	/* cx (dummy value) */
				*p++ = 1000;	/* cy (dummy value) */
				*p++ = 0;		/* Menu */
				*p++ = 0;		/* Class */

				/* copy the title of the dialog */
				nchar = nCopyAnsiToWideChar (p, (char *) pcci->p1);
				p += nchar;
				/* Font information because of DS_SETFONT */
				*p++ = 8;		/* point size */
				nchar = nCopyAnsiToWideChar (p, "MS Sans Serif");		/* Face name */
				p += nchar;
				/* make sure the first item starts on a DWORD boundary */

				hwnd = CreateDialogIndirectParam (ghInst, (LPDLGTEMPLATE) pdlgtemplate, ghMainWindow, (DLGPROC) DialogProcedure, (LPARAM) 0);

				LocalFree (LocalHandle (pdlgtemplate));

				ShowWindow (hwnd, SW_SHOWNORMAL);
				UpdateWindow (hwnd);

				MakeReturn1Cci (pcci, (int) hwnd);
			}
			break;
		case CcRqMODALDIALOG:	/* textptr, x,y,w,h;
								   HWND result. */
			{
				WORD *p, *pdlgtemplate;
				int nchar;
				char *title;
				DWORD lStyle;

				/* allocate some memory to play with  */
				pdlgtemplate = p = (PWORD) rmalloc (1000);

				/* start to fill in the dlgtemplate information.  addressing
				   by WORDs */
				lStyle = WS_CAPTION | DS_SETFONT;
				*p++ = LOWORD (lStyle);
				*p++ = HIWORD (lStyle);
				*p++ = 0;		/* LOWORD (lExtendedStyle) */
				*p++ = 0;		/* HIWORD (lExtendedStyle) */
				*p++ = 0;		/* NumberOfItems */
				*p++ = (WORD) - 1;		/* x  (dummy value) */
				*p++ = (WORD) - 1;		/* y  (dummy value) */
				*p++ = 1;		/* cx (dummy value) */
				*p++ = 1;		/* cy (dummy value) */
				*p++ = 0;		/* Menu */
				*p++ = 0;		/* Class */

				/* copy the title of the dialog */
				nchar = nCopyAnsiToWideChar (p, (char *) pcci->p1);
				p += nchar;
				/* Font information because of DS_SETFONT */
				*p++ = 8;		/* point size */
				nchar = nCopyAnsiToWideChar (p, "MS Sans Serif");		/* Face name */
				p += nchar;
				/* make sure the first item starts on a DWORD boundary */

				title = (char *) pcci->p1;

				if (IsWindowEnabled (ghMainWindow))
				{
					gModalDialogCount++;
					DialogBoxIndirectParam (ghInst, (LPDLGTEMPLATE) pdlgtemplate, ghMainWindow, (DLGPROC) DialogProcedure, (LPARAM) 0);
					ActivateTopWindow ();
					gModalDialogCount--;
				}
				else
				{
					HWND activedialog;

					activedialog = GetActiveWindow ();
					gModalDialogCount++;
					DialogBoxIndirectParam (ghInst, (LPDLGTEMPLATE) pdlgtemplate, activedialog, (DLGPROC) DialogProcedure, (LPARAM) 0);
					gModalDialogCount--;
				}

				LocalFree (LocalHandle (pdlgtemplate));
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqENDMODALDLOG:	/* hwnd; no result. */
			{
				EndDialog ((HWND) pcci->p1, 0);
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqGETACTIVEDIALOG:		/* no params;	 HWND result. */
			{
				HWND hwin, hw;
				HWND found;

				if (gAppRunning)
					ActivateTopWindow ();

				found = NULL;

				hwin = GetWindow (ghMainWindow, GW_HWNDFIRST);
				while (hwin != NULL && found == NULL)
				{

					hw = hwin;
					while (hw != NULL && hw != ghMainWindow)
						hw = GetWindow (hw, GW_OWNER);

					if (hw == ghMainWindow)
					{
						char text[64];

						GetClassName (hwin, text, 63);

						if (!strequal (text, DocWindowClassName) && !strequal (text, MenuBarClassName))
						{
							found = hwin;
						}
						else
						{
						}
					}
					else
					{
					}

					hwin = GetWindow (hwin, GW_HWNDNEXT);
				}

				MakeReturn1Cci (pcci, (int) found);
			}
			break;
		/* PA: new alternative added to create compound controls (window in window) */
		case CcRqCREATECOMPOUND:	/* hwnd, l,t,w,h, scrollbars;
										   HWND result. */
			{
				HWND parentwindow, compoundhandle;
				int left,top, width,height;
				int compoundstyle;

				parentwindow  = (HWND) pcci->p1;
				left          = pcci->p2;
				top	          = pcci->p3;
				width         = pcci->p4;
				height        = pcci->p5;
				compoundstyle = pcci->p6;

				compoundstyle |= WS_CHILD;

				/* create the compound window */
				compoundhandle
					= CreateWindowEx (WS_EX_NOPARENTNOTIFY,		/* Extended style				 */
									  CompoundClassName,		/* Class name					 */
									  "",						/* Window title 				 */
									  compoundstyle,			/* style flags					 */
									  left, top,				/* x, y 						 */
									  width, height,		 	/* width, height				 */
									  parentwindow,				/* Parent window				 */
									  NULL,						/* menu handle					 */
									  (HANDLE) ghInst,			/* Instance that owns the window */
									  0);
				ShowWindow (compoundhandle, SW_SHOWNORMAL);
				MakeReturn1Cci (pcci, (int) compoundhandle);
			}
			break;
		/* PA: new alternative added to create scrollbars. */
		case CcRqCREATESCROLLBAR:	/* hwnd, x,y,w,h bool; HWND result. */
			{
				HWND scroll;
				int style = WS_VISIBLE | WS_CHILD | WS_GROUP;
				int x, y, w, h;
				HWND parent;
				BOOL ishorizontal;

				parent = (HWND) pcci->p1;
				x = pcci->p2;
				y = pcci->p3;
				w = pcci->p4;
				h = pcci->p5;
				ishorizontal = pcci->p6;

				if (ishorizontal)
				{
					style |= SBS_HORZ;
				}
				else
				{
					style |= SBS_VERT;
				}

				scroll = CreateWindow ("scrollbar", "", style,
										x, y, w, h,
										parent, 0, ghInst, 0);

				MakeReturn1Cci (pcci, (int) scroll);
			}
			break;
		case CcRqCREATEBUTTON:	/* hwnd, x,y,w,h, bool;  HWND result. */
			{
				HWND but;
				int style = WS_VISIBLE | WS_CHILD | WS_GROUP | WS_TABSTOP;
				int x, y, w, h;
				HWND parent;
				BOOL isdef;
				int id;

				parent = (HWND) pcci->p1;
				x = pcci->p2;
				y = pcci->p3;
				w = pcci->p4;
				h = pcci->p5;
				isdef = pcci->p6;

				if (isdef)
				{
					style |= BS_DEFPUSHBUTTON;
					id = IDOK;
				}
				else
				{
					style |= BS_PUSHBUTTON;
					id = 0;
				}

				but = CreateWindow ("button", "", style,
									x, y, w, h,
									parent, (HMENU) id, ghInst, 0);

				MakeReturn1Cci (pcci, (int) but);
			}
			break;
		case CcRqCREATEICONBUT: /* hwnd, x,y,w,h;	  HWND result. */
			{
				HWND but;
				int style = WS_VISIBLE | WS_CHILD | WS_GROUP | WS_TABSTOP;
				int x, y, w, h;
				HWND parent;

				parent = (HWND) pcci->p1;
				x = pcci->p2;
				y = pcci->p3;
				w = pcci->p4;
				h = pcci->p5;

				style |= BS_OWNERDRAW;

				but = CreateWindow ("button", "", style,
									x, y, w, h,
									parent, (HMENU) 0, ghInst, 0);

				MakeReturn1Cci (pcci, (int) but);
			}
			break;
		case CcRqCREATECUSTOM:	/* hwnd, x,y,w,h;
								   WND result. */
			{
				HWND ctrl;
				int style;
				int x, y, w, h;
				HWND parent;

				parent = (HWND) pcci->p1;
				x = pcci->p2;
				y = pcci->p3;
				w = pcci->p4;
				h = pcci->p5;

				style = WS_VISIBLE | WS_CHILD | WS_GROUP | WS_TABSTOP;	/* PA: WS_TABSTOP added */

				ctrl = CreateWindow (ControlClassName, "", style,
								  x, y, w, h, parent, (HMENU) 0, ghInst, 0);

				MakeReturn1Cci (pcci, (int) ctrl);
			} break;
		case CcRqCREATESTATICTXT:		/* hwnd, x,y,w,h;
										   HWND result. */
			{
				HWND handle;
				int x, y, w, h, style;
				HWND parent;

				parent = (HWND) pcci->p1;
				x = pcci->p2;
				y = pcci->p3;
				w = pcci->p4;
				h = pcci->p5;

				style = WS_CHILD | WS_VISIBLE | WS_GROUP | SS_LEFT;

				handle = CreateWindow ("static", "", style,
									   x, y, w, h,
									   parent, 0, ghInst, 0);

				MakeReturn1Cci (pcci, (int) handle);
			}
			break;
		case CcRqCREATEEDITTXT: /* hwnd, x,y,w,h, flags; HWND result. */
			{
				HWND handle;
				int x, y, w, h, style, flags;
				HWND parent;
				BOOL isml,isKeySensitive;

				parent         = (HWND) pcci->p1;
				x              = pcci->p2;
				y              = pcci->p3;
				w              = pcci->p4;
				h              = pcci->p5;
				flags          = pcci->p6;
				isml           = flags & EDITISMULTILINE;
				isKeySensitive = flags & EDITISKEYSENSITIVE;

				style = WS_CHILD | WS_VISIBLE | WS_GROUP | WS_TABSTOP | ES_LEFT;

				if (isml)
					style |= ES_AUTOVSCROLL | ES_MULTILINE | ES_WANTRETURN;
				else
					style |= ES_AUTOHSCROLL;

				handle = CreateWindowEx (WS_EX_CLIENTEDGE, "edit", "", style,
										 x, y, w, h,
										 parent, 0, ghInst, 0);
				
				/* PA:	store the standard Windows callback routine adress in stdEditCallback
						and subclass the edit control with EditControlProcedure.
				*/
				if (isKeySensitive)
					stdEditCallback = SetWindowLong (handle, GWL_WNDPROC, (LONG) EditControlProcedure);

				MakeReturn1Cci (pcci, (int) handle);
			}
			break;
		case CcRqCREATERADIOBUT:		/* hwnd, x,y,w,h, isfirst;	HWND
										   result. */
			{
				HWND handle;
				int x, y, w, h, style;
				HWND parent;
				BOOL first;

				parent = (HWND) pcci->p1;
				x = pcci->p2;
				y = pcci->p3;
				w = pcci->p4;
				h = pcci->p5;
				first = pcci->p6;

				style = WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON | WS_TABSTOP;
				if (first)
					style |= WS_GROUP;

				handle = CreateWindow ("button", "", style,
									   x, y, w, h,
									   parent, 0, ghInst, 0);

				MakeReturn1Cci (pcci, (int) handle);
			}
			break;
		case CcRqCREATECHECKBOX:		/* hwnd, x,y,w,h, isfirst;
										   HWND result. */
			{
				HWND handle;
				int x, y, w, h, style;
				HWND parent;
				BOOL first;

				parent = (HWND) pcci->p1;
				x = pcci->p2;
				y = pcci->p3;
				w = pcci->p4;
				h = pcci->p5;
				first = pcci->p6;

				style = WS_CHILD | WS_VISIBLE | BS_AUTOCHECKBOX | WS_TABSTOP;

				if (first)
					style |= WS_GROUP;

				handle = CreateWindow ("button", "", style,
									   x, y, w, h,
									   parent, 0, ghInst, 0);

				MakeReturn1Cci (pcci, (int) handle);
			}
			break;
		case CcRqSETITEMCHECK:	/* hwnd, bool; no result. */
			{
				HWND hwnd;
				BOOL on;
				int check;

				hwnd = (HWND) pcci->p1;
				on = pcci->p2;

				if (on)
					check = 1;
				else
					check = 0;

				SendMessage (hwnd, BM_SETCHECK, (WPARAM) check, 0);

				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqENABLECONTROL: /* hwnd, bool; no result. */
			{
				HWND window;
				BOOL wasUnable, newSelect;

				window    = (HWND) pcci->p1;
				newSelect = (BOOL) pcci->p2;
				
				wasUnable = EnableWindow (window, newSelect);
				if (wasUnable != newSelect)
					InvalidateRect (window, NULL, FALSE);

				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqSHOWCONTROL:	/* hwnd, bool; no result. */
			{
				int nCmdShow;

				if (pcci->p2) 
					nCmdShow = SW_SHOW;
				else
					nCmdShow = SW_HIDE;

				ShowWindow ((HWND) pcci->p1, nCmdShow);
				MakeReturn0Cci (pcci);
			}
			break;
		/* PA: new alternative added to hide/show windows. */
		case CcRqSHOWWINDOW:	/* hwnd, show, activate; no result. */
			{
				int nCmdShow;

				if (!pcci->p2)
					nCmdShow = SW_HIDE;
				else if (pcci->p3)
					nCmdShow = SW_SHOW;
				else 
					nCmdShow = SW_SHOWNOACTIVATE;

				ShowWindow ((HWND) pcci->p1, nCmdShow);
				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqCREATEPOPUP:	/* hwnd, x,y,w,h;  HWND result. */

			{
				HWND parent, handle;
				int x, y, w, h;
				int style;

				parent = (HWND) pcci->p1;
				x = pcci->p2;
				y = pcci->p3;
				w = pcci->p4;
				h = pcci->p5;

				style = WS_CHILD | WS_VISIBLE | WS_GROUP | WS_TABSTOP | WS_VSCROLL |
					CBS_DROPDOWNLIST | CBS_AUTOHSCROLL | CBS_OWNERDRAWFIXED | CBS_HASSTRINGS;

				handle = CreateWindowEx (0, "COMBOBOX", "", style,
										 x, y, w, h,
										 parent, (HMENU) 0, ghInst, 0);
				SendMessage (handle, CB_SETEXTENDEDUI, (WPARAM) TRUE, 0);

				MakeReturn1Cci (pcci, (int) handle);
			}
			break;
		case CcRqADDTOPOPUP:	/* hwnd, textptr, enabled, selected;
								   Pos result. */

			{
				int pos;
				HWND hpopup;
				char *text;
				BOOL enabled, selected;

				hpopup = (HWND) pcci->p1;
				text = (char *) pcci->p2;
				enabled = (BOOL) pcci->p3;
				selected = (BOOL) pcci->p4;

				pos = SendMessage (hpopup, CB_ADDSTRING, 0, (LPARAM) text);

				SendMessage (hpopup, CB_SETITEMDATA, (WPARAM) pos, (LPARAM) enabled);

				if (selected)
				{
					SendMessage (hpopup, CB_SETCURSEL, (WPARAM) pos, 0);
				}

				MakeReturn1Cci (pcci, pos);
			}
			break;
		case CcRqSELECTPOPUPITEM:		/* hwnd, pos; no result */
			{
				HWND hpopup;
				int pos;

				hpopup = (HWND) pcci->p1;
				pos = pcci->p2;

				SendMessage (hpopup, CB_SETCURSEL, (WPARAM) pos, 0);

				MakeReturn0Cci (pcci);
			}
			break;
		case CcRqENABLEPOPUPITEM:		/* hwnd, pos, enabled; no result */
			{
				HWND hpopup;
				int pos;
				LPARAM enabled;

				hpopup = (HWND) pcci->p1;
				pos = pcci->p2;
				enabled = (LPARAM) pcci->p3;

				SendMessage (hpopup, CB_SETITEMDATA, (WPARAM) pos, enabled);
				if (SendMessage (hpopup, CB_GETCURSEL, 0, 0) == pos)
				{
					InvalidateRect (hpopup, NULL, TRUE);
					/* UpdateWindow(hpopup); */
				}

				MakeReturn0Cci (pcci);
			}
			break;
		/* PA: CcRqCLIPBOARDHASTEXT had no implementation. It checks if the clipboard has a CF_TEXT item. */
		case CcRqCLIPBOARDHASTEXT:		/* no arguments; bool result. */
			{
				BOOL ok = IsClipboardFormatAvailable (CF_TEXT);
				MakeReturn1Cci (pcci,(int) ok);
			}
			break;
		case CcRqSETCLIPBOARDTEXT:		/* textptr; no result. */
			{
				HANDLE hClipText;
				char *pClipText;
				int len;
				char *txt;

				txt = (char *) pcci->p1;

				len = lstrlen (txt);
				hClipText = GlobalAlloc (GMEM_MOVEABLE | GMEM_DDESHARE, len + 1);

				if (hClipText != NULL)
				{
					pClipText = GlobalLock (hClipText);
					lstrcpyn (pClipText, txt, len + 1);
					GlobalUnlock (hClipText);

					OpenClipboard (ghMainWindow);
					EmptyClipboard ();
					SetClipboardData (CF_TEXT, hClipText);
					CloseClipboard ();
				}
				MakeReturn0Cci (pcci);
			} break;
		case CcRqGETCLIPBOARDTEXT:		/* no params; string result. */
			{
				HANDLE hClipText;
				char *pClipText;
				char *result;
				int len;

				OpenClipboard (ghMainWindow);
				hClipText = GetClipboardData (CF_TEXT);

				if (hClipText == NULL)
				{
					result = rmalloc (1);
					result[0] = '\0';
				}
				else
				{
					len = GlobalSize (hClipText) - 1;
					result = rmalloc (len + 1);

					pClipText = GlobalLock (hClipText);
					len = lstrlen (pClipText);

					lstrcpyn (result, pClipText, len + 1);
					GlobalUnlock (hClipText);
				}
				CloseClipboard ();

				MakeReturn1Cci (pcci, (int) result);
			} break;
		/* PA: new alternative that implements WinRestackWindow as a crosscall operation. */
		case CcRqRESTACKWINDOW:		/* thewindow,behind; no result. */
			{
				HWND thePtr, behindPtr;
				UINT uflags;

				thePtr    = (HWND) pcci->p1;
				behindPtr = (HWND) pcci->p2;

				uflags = SWP_NOMOVE + SWP_NOSIZE;	/* PA: do not change current size or location */
				SetWindowPos (thePtr, behindPtr, 0, 0, 0, 0, uflags);

				MakeReturn0Cci (pcci);
			} break;
		default:
			{
				rprintf ("\'HandleCleanRequest\' got unkown request from Clean:  ");
				printCCI (pcci);
				ErrorExit ("\'HandleCleanRequest\' got unkown request from Clean: %d\n", pcci->mess);
			}
	}
	KickCleanThread (pcci);
}


/* RWS :		The shortcut table routines that are called from Clean are here
						for IO lib 0.8. In IO lib 1.0 the shortcut administration is
						(currently) done entirely in C.
*/
void
WinAllocShortcutTable (int size, OS ios, LPACCEL * acc, OS * oos)
{
	*acc = (LPACCEL) rmalloc (size * sizeof (ACCEL));
	*oos = ios;
}

OS
WinCopyShortcutToTable (int key, int id, int pos, LPACCEL acc, OS os)
{
	acc[pos].fVirt = FCONTROL | FVIRTKEY;
	acc[pos].key = (WORD) ((BYTE) VkKeyScan ((char) key));
	acc[pos].cmd = (WORD) id;

	return os;
}

OS
WinActivateShortcutTable (LPACCEL acc, int size, OS os)
{
	if (gAcceleratorTable != NULL)
		DestroyAcceleratorTable (gAcceleratorTable);

	gAcceleratorTable = CreateAcceleratorTable (acc, size);

	return os;
}

OS
WinSetShortcut (int id, int key, OS os)
{
	rprintf ("WinSetShortcut: id = %d, key = %d\n", id, key);

	if (gShortcutTable == NULL)
		gShortcutTable = AllocateShortcutTable (kInitialShortcutTableSize);

	RemoveShortcutFromTable (id, gShortcutTable);
	gShortcutTable = AddShortcutToTable (key, id, gShortcutTable);

	return (os);
}

OS
WinDestroyMenu (HMENU menu, OS os)
{
	rprintf ("DestroyMenu: menu = %d\n", (int) menu);

	DestroyMenu (menu);
	return (os);
}

BOOL
CleanThreadRunning (void)
{
	return GetCurrentThreadId () == gCleanThreadId;
}

BOOL
OsThreadRunning (void)
{
	return GetCurrentThreadId () == gOsThreadId;
}

extern EXPORT_TO_CLEAN void
WinInitOs (Bool * ok, OS * os)
{
	if (gEventsInited)
	{
		*ok = FALSE;
		rprintf ("WIO: *ok = FALSE\n");
	}
	else
	{
		*ok = TRUE;
		gEventsInited = TRUE;
		rprintf ("WIO: *ok = TRUE\n");
	}

	*os = 54321;
}

extern EXPORT_TO_CLEAN Bool
WinCloseOs (OS os)
{
#pragma unused (os)

	if (gEventsInited)
	{
		rprintf ("WCO: return TRUE\n");
		gEventsInited = FALSE;
		return TRUE;
	}
	else
	{
		rprintf ("WCO: return FALSE\n");
		return FALSE;
	}
}

extern EXPORT_TO_CLEAN OS
WinStartOsThread (OS os)
{
	rprintf ("WSOT: Started\n");

	InitGlobals ();
	rprintf ("WSOT: Globals Inited\n");
	gCLEAN_DONE = CreateEvent (NULL,	/* Default security attributes	*/
							   FALSE,	/* Not a manual-reset event 	*/
							   FALSE,	/* Initial state nonsignalled	*/
							   NULL);	/* No name						*/
	Check ((BOOL) gCLEAN_DONE, "\'InitOs\' could not create first event object");
	rprintf ("WSOT: CLEANDONE event created\n");

	gOS_DONE = CreateEvent (NULL, FALSE, FALSE, NULL);
	Check ((BOOL) gOS_DONE, "\'InitOs\' could not create second event object");
	rprintf ("WSOT: OS_DONE event created\n");

	gCleanThreadId = GetCurrentThreadId ();
	rprintf ("WSOT: gor current thread id\n");

	ghOSThreadHandle = CreateThread (NULL,		/* Default security
												   attributes	 */
									 0, /* Default stacksize			  */
								  (LPTHREAD_START_ROUTINE) OsThreadFunction,
									 0, /* parameter to thread function   */
									 0, /* Not initially suspended		  */
									 &(gOsThreadId));	/* store threadId here	*/
	Check ((BOOL) ghOSThreadHandle, "\'InitOs\' could not create second thread");
	rprintf ("WSOT: new thread created\n");
	WaitForSingleObject (gOS_DONE, INFINITE);
	rprintf ("WSOT: wait done\n");

	return os;
}

extern EXPORT_TO_CLEAN OS
WinKillOsThread (OS os)
{
	rprintf ("OS WinKillOsThread (OS os)\n");
	if (ghOSThreadHandle != NULL)
	{
		rprintf ("ghOSThreadHandle != NULL\n");
		TerminateThread (ghOSThreadHandle, 0);
		rprintf ("		TerminateThread(ghOSThreadHandle, 0);\n");
		ghOSThreadHandle = NULL;
		rprintf ("		ghOSThreadHandle = NULL;\n");

		/* CleanUp */
		if (gAcceleratorTable)
			DestroyAcceleratorTable (gAcceleratorTable);
		rprintf ("		if (gAcceleratorTable) \n");
		rprintf ("				DestroyAcceleratorTable( gAcceleratorTable );\n");
		DeleteCursors ();
		rprintf ("		DeleteCursors();\n");
		CloseHandle (gOS_DONE);
		gOS_DONE = NULL;
		rprintf ("		CloseHandle(gOS_DONE);	  gOS_DONE	  = NULL;\n");
		CloseHandle (gCLEAN_DONE);
		gCLEAN_DONE = NULL;
		rprintf ("		CloseHandle(gCLEAN_DONE); gCLEAN_DONE = NULL;\n");
		if (gDlogFont != NULL)
			DeleteObject (gDlogFont);
		rprintf ("		if(gDlogFont != NULL)\n");
		rprintf ("		   DeleteObject(gDlogFont);\n");
		if (gWinFont != NULL)
			DeleteObject (gWinFont);
		rprintf ("      if(gWinFont != NULL)\n");
		rprintf ("         DeleteObject(gWinFont);\n");

	}

	return os;
}

extern EXPORT_TO_CLEAN void
WinKickOsThread (int imess,
				 int ip1, int ip2, int ip3,
				 int ip4, int ip5, int ip6,
				 OS ios,
				 int *omess,
				 int *op1, int *op2, int *op3,
				 int *op4, int *op5, int *op6,
				 OS * oos)
{

/*				rprintf("KOT: filling in Cci\n"); */
	rprintf ("WinKickOsThread (");
	printCCI (&gCci);
	rprintf (")\n");

	gCci.mess = imess;
	gCci.p1 = ip1;
	gCci.p2 = ip2;
	gCci.p3 = ip3;
	gCci.p4 = ip4;
	gCci.p5 = ip5;
	gCci.p6 = ip6;

	if (ghOSThreadHandle != NULL)
	{
		rprintf ("KOT: Cci filled in, setting event\n");
		SetEvent (gCLEAN_DONE);
		rprintf ("KOT: Event set, start wait.\n");
		WaitForSingleObject (gOS_DONE, INFINITE);
		rprintf ("KOT: wait done, reading out Cci.\n");
		*omess = gCci.mess;
		*op1 = gCci.p1;
		*op2 = gCci.p2;
		*op3 = gCci.p3;
		*op4 = gCci.p4;
		*op5 = gCci.p5;
		*op6 = gCci.p6;
		*oos = ios;
		rprintf ("KOT: Cci read: {");
		printCCI (&gCci);
		rprintf ("}\n");
	}
	else
	{
		rprintf ("KOT: no thread existed, returning CcWASQUIT for <");
		printCCI (&gCci);
		rprintf (">\n");
		*omess = CcWASQUIT;
		*op1 = 0;
		*op2 = 0;
		*op3 = 0;
		*op4 = 0;
		*op5 = 0;
		*op6 = 0;
		*oos = ios;
	}
	rprintf ("KOT: done.\n");
}

#define PRINTCROSSCALLS

#ifdef PRINTCROSSCALLS
static CrossCallInfo osstack[10];
static CrossCallInfo clstack[10];
static int ossp = -1;
static int clsp = -1;
#endif

void
KickCleanThread (CrossCallInfo * pcci)
{

#ifdef PRINTCROSSCALLS
	if (ossp == -1)
	{
		for (ossp = 0; ossp < 10; ossp++)
		{
			osstack[ossp].mess = -1;
		}
		ossp = 1;
		osstack[ossp].mess = -2;
	}

	if (clsp == -1)
	{
		for (clsp = 0; clsp < 10; clsp++)
		{
			clstack[clsp].mess = -1;
		}
		clsp = 1;
		clstack[clsp].mess = -2;
	}
#endif

	if (pcci != &gCci)
		gCci = *pcci;
	rprintf ("KCT: started\n");

#ifdef PRINTCROSSCALLS
	if (gCci.mess < 20)
	{
		rprintf ("	-- %d --> OS returning <", clsp + ossp - 2);
		printCCI (&gCci);
		rprintf ("> from <");
		printCCI (&(clstack[clsp]));
		rprintf (">\n");
		clsp--;
	}
	else
	{
		ossp++;
		osstack[ossp] = gCci;
		rprintf ("	-- %d --> OS calling with <", clsp + ossp - 2);
		printCCI (&gCci);
		rprintf (">\n");
	}
#endif

	rprintf ("KCT: setting event\n");
	SetEvent (gOS_DONE);
	rprintf ("KCT: starting wait\n");
	WaitForSingleObject (gCLEAN_DONE, INFINITE);
	rprintf ("KCT: wait done.\n");

	if (pcci != &gCci)
		*pcci = gCci;

#ifdef PRINTCROSSCALLS
	if (gCci.mess < 20)
	{
		rprintf (" <-- %d --  Clean returning <", clsp + ossp - 2);
		printCCI (&gCci);
		rprintf ("> from <");
		printCCI (&(osstack[ossp]));
		rprintf (">\n");
		ossp--;
	}
	else
	{
		clsp++;
		clstack[clsp] = gCci;
		rprintf (" <-- %d --  Clean calling with <", clsp + ossp - 2);
		printCCI (&gCci);
		rprintf (">\n");
	}
#endif
}

void
SendMessageToClean (int mess,
					int p1, int p2, int p3,
					int p4, int p5, int p6)
{
	gCci.mess = mess;
	gCci.p1 = p1;
	gCci.p2 = p2;
	gCci.p3 = p3;
	gCci.p4 = p4;
	gCci.p5 = p5;
	gCci.p6 = p6;

	KickCleanThread (&gCci);
	while (!IsReturnCci (&gCci))
	{
		HandleCleanRequest (&gCci);
	}
}

extern double c_div_real (double n, double d);
extern int c_ftoi (double d);

DWORD
OsThreadFunction (DWORD param)
{
	WNDCLASS wclass;
	int width, height;

#pragma unused (param)

	/* register menu window class */
	wclass.style = CS_NOCLOSE;
	wclass.lpfnWndProc = (WNDPROC) MenuWindowProcedure;
	wclass.cbClsExtra = 0;
	wclass.cbWndExtra = 0;
	wclass.hInstance = ghInst;
	wclass.hIcon = LoadIcon (ghInst, IDI_APPLICATION);
	wclass.hCursor = LoadCursor (ghInst, IDC_ARROW);
	wclass.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH);
	wclass.lpszMenuName = NULL;
	wclass.lpszClassName = MenuBarClassName;
	RegisterClass (&wclass);

	/* register custom control class */
	wclass.style = CS_NOCLOSE;
	wclass.lpfnWndProc = (WNDPROC) CustomControlProcedure;
	wclass.cbClsExtra = 0;
	wclass.cbWndExtra = 0;
	wclass.hInstance = ghInst;
	wclass.hIcon = NULL;
	wclass.hCursor = LoadCursor (ghInst, IDC_ARROW);
	wclass.hbrBackground = (HBRUSH) (COLOR_BTNFACE + 1);
	wclass.lpszMenuName = NULL;
	wclass.lpszClassName = ControlClassName;
	RegisterClass (&wclass);

	/* register clean compound control class */
	wclass.style = 0;
	wclass.lpfnWndProc = (WNDPROC) CompoundControlProcedure;
	wclass.cbClsExtra = 0;
	wclass.cbWndExtra = 0;
	wclass.hInstance = ghInst;
	wclass.hIcon = NULL;
	wclass.hCursor = LoadCursor (ghInst, IDC_ARROW);
	wclass.hbrBackground = (HBRUSH) GetStockObject (NULL_BRUSH);
	wclass.lpszMenuName = NULL;
	wclass.lpszClassName = CompoundClassName;
	RegisterClass (&wclass);

	/* register clean window class */
	wclass.style = CS_HREDRAW | CS_VREDRAW;
	wclass.lpfnWndProc = (WNDPROC) CleanWindowProcedure;
	wclass.cbClsExtra = 0;
	wclass.cbWndExtra = 0;
	wclass.hInstance = ghInst;
	wclass.hIcon = LoadIcon (ghInst, IDI_APPLICATION);
	wclass.hCursor = LoadCursor (ghInst, IDC_ARROW);		// PA: NULL changed to default arrow cursor;
	wclass.hbrBackground = (HBRUSH) GetStockObject (NULL_BRUSH);
	wclass.lpszMenuName = NULL;
	wclass.lpszClassName = DocWindowClassName;
	RegisterClass (&wclass);

	/* register main window class */
	wclass.style = CS_NOCLOSE;
	wclass.lpfnWndProc = (WNDPROC) MainWindowProcedure;
	wclass.cbClsExtra = 0;
	wclass.cbWndExtra = 0;
	wclass.hInstance = ghInst;
	wclass.hIcon = LoadIcon (ghInst, IDI_APPLICATION);
	wclass.hCursor = LoadCursor (ghInst, IDC_ARROW);
	wclass.hbrBackground = NULL;
	wclass.lpszMenuName = NULL;
	wclass.lpszClassName = MainWindowClassName;
	RegisterClass (&wclass);

	GetAppFileName ();

	width = GetSystemMetrics (SM_CXMAXIMIZED)
		- 2 * GetSystemMetrics (SM_CXSIZEFRAME);
	height = 2 * GetSystemMetrics (SM_CYSIZEFRAME) +
		GetSystemMetrics (SM_CYCAPTION) +
		GetSystemMetrics (SM_CYMENU);

	ghMainWindow
		= CreateWindow (MainWindowClassName,	/* Class name					 */
						(LPCTSTR) gAppName, 	/* Window title 				 */
						WS_OVERLAPPEDWINDOW,	/* style flags					 */
						0, -5 - height,			/* x, y 						 */
						width, height,			/* width, height 				 */
						NULL,					/* Parent window				 */
						NULL,					/* menu handle					 */
						(HANDLE) ghInst,		/* Instance that owns the window */
						0);
	ShowWindow (ghMainWindow, SW_SHOWNORMAL);

	EnableMenuItem (GetSystemMenu (ghMainWindow, FALSE), SC_MOVE, MF_GRAYED);

	KickCleanThread (MakeReturn0Cci (&gCci));

	while (1)
	{
		HandleCleanRequest (&gCci);
	}

	MakeReturn0Cci (&gCci);
	SetEvent (gOS_DONE);

	return 0;
}

CrossCallInfo *
MakeReturn0Cci (CrossCallInfo * pcci)
{
	pcci->mess = CcRETURN0;
	return pcci;
}

CrossCallInfo *
MakeReturn1Cci (CrossCallInfo * pcci, int v)
{
	pcci->mess = CcRETURN1;
	pcci->p1 = v;
	return pcci;
}

CrossCallInfo *
MakeReturn2Cci (CrossCallInfo * pcci, int v1, int v2)
{
	pcci->mess = CcRETURN2;
	pcci->p1 = v1;
	pcci->p2 = v2;
	return pcci;
}

CrossCallInfo *
MakeReturn3Cci (CrossCallInfo * pcci, int v1, int v2, int v3)
{
	pcci->mess = CcRETURN3;
	pcci->p1 = v1;
	pcci->p2 = v2;
	pcci->p3 = v3;
	return pcci;
}

CrossCallInfo *
MakeReturn4Cci (CrossCallInfo * pcci, int v1, int v2, int v3, int v4)
{
	pcci->mess = CcRETURN4;
	pcci->p1 = v1;
	pcci->p2 = v2;
	pcci->p3 = v3;
	pcci->p4 = v4;
	return pcci;
}

BOOL
IsReturnCci (CrossCallInfo * pcci)
{
	if (pcci->mess >= CcRETURNmin && pcci->mess <= CcRETURNmax)
		return TRUE;

	return FALSE;
}

extern EXPORT_TO_CLEAN void
WinScreenYSize (OS ios, int *py, OS * oos)
{
	*py = GetSystemMetrics (SM_CYSCREEN);

	*oos = ios;
}

extern EXPORT_TO_CLEAN void
WinScreenXSize (OS ios, int *px, OS * oos)
{
	*px = GetSystemMetrics (SM_CXSCREEN);

	*oos = ios;
}

extern EXPORT_TO_CLEAN void
WinMinimumWinSize (int *mx, int *my)
{
	*mx = 48;
	*my = 0;
}

/*		PA: WinScrollbarSize added to determine system metrics of width and height of scrollbars.
*/
extern EXPORT_TO_CLEAN void
WinScrollbarSize (OS ios, int *width, int *height, OS * oos)
{
	*width = GetSystemMetrics (SM_CXVSCROLL);
	*height = GetSystemMetrics (SM_CYHSCROLL);

	*oos = ios;
}

extern EXPORT_TO_CLEAN void
WinMaxFixedWindowSize (int *mx, int *my)
{

	*mx = GetSystemMetrics (SM_CXMAXIMIZED) -	/* MAXIMIZED size	  */
	4 * GetSystemMetrics (SM_CXFIXEDFRAME); 	/* window borders	  */

	*my = GetSystemMetrics (SM_CYMAXIMIZED) -	/* MAXIMIZED size	  */
		4 * GetSystemMetrics (SM_CYFIXEDFRAME) -		/* window borders	  */
		GetSystemMetrics (SM_CYCAPTION) -		/* title bar		  */
		GetMenuBarOffSet ();
}

extern EXPORT_TO_CLEAN void
WinMaxScrollWindowSize (int *mx, int *my)
{
	*mx = GetSystemMetrics (SM_CXMAXIMIZED) -	/* MAXIMIZED size	  */
	4 * GetSystemMetrics (SM_CXSIZEFRAME) - 	/* window borders	  */
	4;	/* 2 * client edge	  */

	*my = GetSystemMetrics (SM_CYMAXIMIZED) -	/* MAXIMIZED size	  */
		4 * GetSystemMetrics (SM_CYSIZEFRAME) - /* window borders	  */
		4 - 	/* 2 * clientedge	  */
		GetSystemMetrics (SM_CYCAPTION) -		/* title bar		  */
		GetMenuBarOffSet ();
}

extern EXPORT_TO_CLEAN CLEAN_STRING
WinGetModulePath (void)
{
	char path[MAX_PATH + 1];

	GetModuleFileName (NULL, path, MAX_PATH);

	return cleanstring (path);
}

extern EXPORT_TO_CLEAN void
WinFileModifiedDate (CLEAN_STRING name, Bool * exists, int *yy, int *mm, int *dd, int *h, int *m, int *s)
{
	char *file_name;
	HANDLE handle;
	WIN32_FIND_DATA find_data;

	file_name = cstring (name);

	handle = FindFirstFile (file_name, &find_data);

	if (handle != INVALID_HANDLE_VALUE)
	{
		SYSTEMTIME system_time;

		FindClose (handle);

		if (FileTimeToSystemTime (&find_data.ftLastWriteTime, &system_time))
		{
			*exists = TRUE;
			*yy = system_time.wYear;
			*mm = system_time.wMonth;
			*dd = system_time.wDay;
			*h = system_time.wHour;
			*m = system_time.wMinute;
			*s = system_time.wSecond;
			return;
		}
	}

	*exists = FALSE;
	*yy = 0;
	*mm = 0;
	*dd = 0;
	*h = 0;
	*m = 0;
	*s = 0;
}

extern EXPORT_TO_CLEAN Bool
WinFileExists (CLEAN_STRING name)
{
	char *file_name;
	HANDLE handle;
	WIN32_FIND_DATA find_data;

	file_name = cstring (name);

	handle = FindFirstFile (file_name, &find_data);

	if (handle != INVALID_HANDLE_VALUE)
	{
		FindClose (handle);

		return TRUE;
	}
	else
		return FALSE;
}

extern EXPORT_TO_CLEAN void
WinCallProcess (PSTR commandline,
				PSTR env,
				PSTR dir,
				PSTR in,
				PSTR out,
				PSTR err,
				OS ios,
				Bool * success,
				int *exitcode,
				OS * oos)
{
	SECURITY_ATTRIBUTES sa;
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	BOOL fsuccess;
	char *ep;
	HANDLE saveStdin, infile;
	HANDLE saveStdout, outfile;
	HANDLE saveStderr, errfile;

	rprintf ("WCP: starting...\n");

	rprintf ("success = %d, value = %d\n", success, *success);
	*success = FALSE;
	rprintf ("exitcode = %d; value = %d\n", exitcode, *exitcode);
	*exitcode = -1;
	rprintf ("oos = %d; value = %d\n", oos, *oos);
	*oos = ios;

	rprintf ("commandline = %d; value = %s\n", commandline, commandline);

	if (commandline != NULL)
		rprintf ("WCP: commandline = \"%s\"\n", commandline);
	else
		rprintf ("WCP: commandline empty\n");

	if (env != NULL)
	{
		ep = env;
		while (rstrlen (ep) != 0)
		{
			rprintf ("WCP:		   env = \"%s\"\n", ep);
			ep += rstrlen (ep) + 1;
		}
	}
	else
		rprintf ("WCP:		   env empty\n");

	if (dir != NULL)
		rprintf ("WCP: dir = \"%s\"\n", dir);
	else
		rprintf ("WCP: dir empty\n");

	if (in != NULL)
		rprintf ("WCP: in = \"%s\"\n", in);
	else
		rprintf ("WCP: in empty\n");

	if (out != NULL)
		rprintf ("WCP: out = \"%s\"\n", out);
	else
		rprintf ("WCP: out empty\n");

	if (err != NULL)
		rprintf ("WCP: err = \"%s\"\n", err);
	else
		rprintf ("WCP: err empty\n");

	sa.nLength = sizeof (SECURITY_ATTRIBUTES);
	sa.bInheritHandle = TRUE;
	sa.lpSecurityDescriptor = NULL;

	if (in != NULL)
	{
		infile = CreateFile (in,
							 GENERIC_READ,
							 FILE_SHARE_READ | FILE_SHARE_WRITE,
							 &sa,
							 OPEN_EXISTING,
							 FILE_ATTRIBUTE_NORMAL,
							 NULL
			);
		if (infile == INVALID_HANDLE_VALUE)
		{
			rprintf ("infile creation failed\n");
			return;
		}

		saveStdin = GetStdHandle (STD_INPUT_HANDLE);

		if (!SetStdHandle (STD_INPUT_HANDLE, infile))
		{
			rprintf ("could not redirect input\n");
			return;
		}
		rprintf ("redirection of input ok\n");
	}
	else
	{
		rprintf ("in == NULL\n");
		infile = NULL;
	}

	if (out != NULL)
	{
		outfile = CreateFile (out,
							  GENERIC_WRITE,
							  0,
							  &sa,
							  CREATE_ALWAYS,
							  FILE_ATTRIBUTE_NORMAL,
							  NULL
			);
		if (outfile == INVALID_HANDLE_VALUE)
		{
			rprintf ("outfile creation failed\n");
			return;
		}

		saveStdout = GetStdHandle (STD_OUTPUT_HANDLE);

		if (!SetStdHandle (STD_OUTPUT_HANDLE, outfile))
		{
			rprintf ("could not redirect output\n");
			return;
		}
		rprintf ("redirection of output ok\n");

	}
	else
	{
		rprintf ("out == NULL\n");
		outfile = NULL;
	}

	if (err != NULL)
	{
		errfile = CreateFile (err,
							  GENERIC_WRITE,
							  0,
							  &sa,
							  CREATE_ALWAYS,
							  FILE_ATTRIBUTE_NORMAL,
							  NULL
			);
		if (errfile == INVALID_HANDLE_VALUE)
		{
			rprintf ("errfile creation failed\n");
			return;
		}

		saveStderr = GetStdHandle (STD_ERROR_HANDLE);

		if (!SetStdHandle (STD_ERROR_HANDLE, errfile))
		{
			rprintf ("could not redirect errput\n");
			return;
		}
		rprintf ("redirection of errors ok\n");
	}
	else
	{
		rprintf ("err == NULL\n");
		errfile = NULL;
	}

	si.cb = sizeof (STARTUPINFO);
	si.lpReserved = NULL;
	si.lpReserved2 = NULL;
	si.cbReserved2 = 0;
	si.lpDesktop = NULL;
	si.lpTitle = NULL;
	si.dwFlags = 0;

	fsuccess =
		CreateProcess (NULL,	/* pointer to name of executable module */
					   commandline, 	/* pointer to command line string */
					   NULL,	/* pointer to process security attributes */
					   NULL,	/* pointer to thread security attributes */
					   TRUE,	/* handle inheritance flag */
					   DETACHED_PROCESS,		/* creation flags */
					   env, 	/* pointer to new environment block */
					   dir, 	/* pointer to current directory name */
					   &si, 	/* pointer to STARTUPINFO */
					   &pi		/* pointer to PROCESS_INFORMATION */
		);
	if (fsuccess)
	{
		rprintf ("WCP: success\n");
		WaitForSingleObject (pi.hProcess, INFINITE);
		GetExitCodeProcess (pi.hProcess, (unsigned long *) exitcode);
		rprintf ("WCP: exitcode = %d\n", *exitcode);
		*success = TRUE;
	}
	else
	{
		rprintf ("WCP: failure %d\n", (int) GetLastError ());
		*success = FALSE;
		*exitcode = -1;
	}

	if (infile != NULL)
	{
		if (SetStdHandle (STD_INPUT_HANDLE, saveStdin))
			rprintf ("resetting stdin ok\n");
		else
			rprintf ("resetting stdin failed\n");

		if (CloseHandle (infile))
			rprintf ("closing infile ok\n");
		else
			rprintf ("closing infile failed\n");
	}
	else
		rprintf ("no need to close and reset input\n");

	if (outfile != NULL)
	{
		if (SetStdHandle (STD_OUTPUT_HANDLE, saveStdout))
			rprintf ("resetting stdout ok\n");
		else
			rprintf ("resetting stdout failed\n");

		if (CloseHandle (outfile))
			rprintf ("closing outfile ok\n");
		else
			rprintf ("closing outfile failed\n");
	}
	else
		rprintf ("no need to close and reset output\n");

	if (errfile != NULL)
	{
		if (SetStdHandle (STD_ERROR_HANDLE, saveStderr))
			rprintf ("resetting stderr ok\n");
		else
			rprintf ("resetting stderr failed\n");

		if (CloseHandle (errfile))
			rprintf ("closing errfile ok\n");
		else
			rprintf ("closing errfile failed\n");
	}
	else
		rprintf ("no need to close and reset errput\n");

	rprintf ("WCP: returning\n");
	/* *oos = ios; */
}

extern EXPORT_TO_CLEAN void
WinLaunchApp (CLEAN_STRING commandline, BOOL console, OS ios, Bool * success, OS * oos)
{
#pragma unused (console)
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	BOOL fsuccess;
	char path[_MAX_PATH];
	char *cl, *thepath;
	int i;
	DWORD error;

	rprintf ("WLA: starting...\n");

	*success = FALSE;
	*oos = ios;
	si.lpTitle = NULL;

	rprintf ("WLA: step 2.\n");

	cl = cstring (commandline);
	lstrcpy (path, cl);

	for (i = lstrlen (path); path[i] != '\\' && i >= 0; i--)
		path[i] = 0;

	if (i == 0)
		thepath = NULL;
	else
	{	/* path[i] = '\"'; */
		thepath = path + 1;
	}

	rprintf ("WLA: step 2a: directory = <%s>\n", thepath);

	rprintf ("WLA: step 3: filling in si.\n");

	si.cb = sizeof (STARTUPINFO);
	si.lpReserved = NULL;
	si.lpReserved2 = NULL;
	si.cbReserved2 = 0;
	si.lpDesktop = NULL;
	si.dwFlags = 0;
	si.lpTitle = NULL;

	rprintf ("WLA: step 4: calling process \"%s\".\n", cl);

	fsuccess =
		CreateProcess (NULL,	/* pointer to name of executable module */
					   cl,		/* pointer to command line string */
					   NULL,	/* pointer to process security attributes */
					   NULL,	/* pointer to thread security attributes */
					   TRUE,	/* handle inheritance flag */
					   0,		/* creation flags */
					   NULL,	/* pointer to new environment block */
					   thepath, /* pointer to current directory name */
					   &si, 	/* pointer to STARTUPINFO */
					   &pi		/* pointer to PROCESS_INFORMATION */
		);
	error = GetLastError ();
	if (fsuccess)
	{
		rprintf ("WLA: success\n");
	}
	else
	{
		rprintf ("WLA: failure %d\n", error);
	}

	rprintf ("WLA: step 5: returning\n");
	*success = fsuccess;
	*oos = ios;
	rprintf ("WLA: done...\n");
}

extern EXPORT_TO_CLEAN void
WinGetTickCount (OS ios, int *tickCount, OS * oos)
{
	*tickCount = GetTickCount ();
	*oos = ios;
}
